// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class MessageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.Message>
{
	private static readonly System.Text.Json.JsonEncodedText PropContent = System.Text.Json.JsonEncodedText.Encode("content");
	private static readonly System.Text.Json.JsonEncodedText PropRole = System.Text.Json.JsonEncodedText.Encode("role");
	private static readonly System.Text.Json.JsonEncodedText PropToolCallId = System.Text.Json.JsonEncodedText.Encode("tool_call_id");
	private static readonly System.Text.Json.JsonEncodedText PropToolCalls = System.Text.Json.JsonEncodedText.Encode("tool_calls");

	public override Elastic.Clients.Elasticsearch.Inference.Message Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject>>?> propContent = default;
		LocalJsonValue<string> propRole = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Id?> propToolCallId = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ToolCall>?> propToolCalls = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propContent.TryReadProperty(ref reader, options, PropContent, static Elastic.Clients.Elasticsearch.Union<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject>>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject>>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.StartArray), null, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.ContentObject>(o, null)!)))
			{
				continue;
			}

			if (propRole.TryReadProperty(ref reader, options, PropRole, null))
			{
				continue;
			}

			if (propToolCallId.TryReadProperty(ref reader, options, PropToolCallId, null))
			{
				continue;
			}

			if (propToolCalls.TryReadProperty(ref reader, options, PropToolCalls, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ToolCall>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.ToolCall>(o, null)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.Message(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Content = propContent.Value,
			Role = propRole.Value,
			ToolCallId = propToolCallId.Value,
			ToolCalls = propToolCalls.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.Message value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropContent, value.Content, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject>>? v) => w.WriteUnionValue<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject>>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.ContentObject>(o, v, null)));
		writer.WriteProperty(options, PropRole, value.Role, null, null);
		writer.WriteProperty(options, PropToolCallId, value.ToolCallId, null, null);
		writer.WriteProperty(options, PropToolCalls, value.ToolCalls, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ToolCall>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.ToolCall>(o, v, null));
		writer.WriteEndObject();
	}
}