// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class JinaAITextEmbeddingTaskConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask>
{
	private static readonly System.Text.Json.JsonEncodedText MemberClassification = System.Text.Json.JsonEncodedText.Encode("classification");
	private static readonly System.Text.Json.JsonEncodedText MemberClustering = System.Text.Json.JsonEncodedText.Encode("clustering");
	private static readonly System.Text.Json.JsonEncodedText MemberIngest = System.Text.Json.JsonEncodedText.Encode("ingest");
	private static readonly System.Text.Json.JsonEncodedText MemberSearch = System.Text.Json.JsonEncodedText.Encode("search");

	public override Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberClassification))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Classification;
		}

		if (reader.ValueTextEquals(MemberClustering))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Clustering;
		}

		if (reader.ValueTextEquals(MemberIngest))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Ingest;
		}

		if (reader.ValueTextEquals(MemberSearch))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Search;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberClassification.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Classification;
		}

		if (string.Equals(value, MemberClustering.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Clustering;
		}

		if (string.Equals(value, MemberIngest.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Ingest;
		}

		if (string.Equals(value, MemberSearch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Search;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Classification:
				writer.WriteStringValue(MemberClassification);
				break;
			case Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Clustering:
				writer.WriteStringValue(MemberClustering);
				break;
			case Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Ingest:
				writer.WriteStringValue(MemberIngest);
				break;
			case Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask.Search:
				writer.WriteStringValue(MemberSearch);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}