// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.JinaAITaskSettingsConverter))]
public sealed partial class JinaAITaskSettings
{
#if NET7_0_OR_GREATER
	public JinaAITaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public JinaAITaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal JinaAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, return the doc text within the results.
	/// </para>
	/// </summary>
	public bool? ReturnDocuments { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the task passed to the model.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>classification</c>: Use it for embeddings passed through a text classifier.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>clustering</c>: Use it for the embeddings run through a clustering algorithm.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ingest</c>: Use it for storing document embeddings in a vector database.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c>: Use it for storing embeddings of search queries run against a vector database to find relevant documents.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask? Task { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of most relevant documents to return.
	/// It defaults to the number of the documents.
	/// If this inference endpoint is used in a <c>text_similarity_reranker</c> retriever query and <c>top_n</c> is set, it must be greater than or equal to <c>rank_window_size</c> in the query.
	/// </para>
	/// </summary>
	public int? TopN { get; set; }
}

public readonly partial struct JinaAiTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JinaAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JinaAiTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings(Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, return the doc text within the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor ReturnDocuments(bool? value = true)
	{
		Instance.ReturnDocuments = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the task passed to the model.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>classification</c>: Use it for embeddings passed through a text classifier.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>clustering</c>: Use it for the embeddings run through a clustering algorithm.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ingest</c>: Use it for storing document embeddings in a vector database.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c>: Use it for storing embeddings of search queries run against a vector database to find relevant documents.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor Task(Elastic.Clients.Elasticsearch.Inference.JinaAITextEmbeddingTask? value)
	{
		Instance.Task = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of most relevant documents to return.
	/// It defaults to the number of the documents.
	/// If this inference endpoint is used in a <c>text_similarity_reranker</c> retriever query and <c>top_n</c> is set, it must be greater than or equal to <c>rank_window_size</c> in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor TopN(int? value)
	{
		Instance.TopN = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.JinaAiTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.JinaAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}