// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.JinaAIServiceSettingsConverter))]
public sealed partial class JinaAIServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JinaAIServiceSettings(string apiKey)
	{
		ApiKey = apiKey;
	}
#if NET7_0_OR_GREATER
	public JinaAIServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public JinaAIServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal JinaAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key of your JinaAI account.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// For a <c>rerank</c> task, it is required.
	/// For a <c>text_embedding</c> task, it is optional.
	/// </para>
	/// </summary>
	public string? ModelId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from JinaAI.
	/// By default, the <c>jinaai</c> service sets the number of requests allowed per minute to 2000 for all task types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the similarity measure. One of cosine, dot_product, l2_norm.
	/// The default values varies with the embedding type.
	/// For example, a float embedding type uses a <c>dot_product</c> similarity measure by default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAISimilarityType? Similarity { get; set; }
}

public readonly partial struct JinaAiServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.JinaAIServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JinaAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.JinaAIServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JinaAiServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.JinaAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.JinaAIServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.JinaAIServiceSettings(Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key of your JinaAI account.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// For a <c>rerank</c> task, it is required.
	/// For a <c>text_embedding</c> task, it is optional.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor ModelId(string? value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from JinaAI.
	/// By default, the <c>jinaai</c> service sets the number of requests allowed per minute to 2000 for all task types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from JinaAI.
	/// By default, the <c>jinaai</c> service sets the number of requests allowed per minute to 2000 for all task types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from JinaAI.
	/// By default, the <c>jinaai</c> service sets the number of requests allowed per minute to 2000 for all task types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the similarity measure. One of cosine, dot_product, l2_norm.
	/// The default values varies with the embedding type.
	/// For example, a float embedding type uses a <c>dot_product</c> similarity measure by default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor Similarity(Elastic.Clients.Elasticsearch.Inference.JinaAISimilarityType? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.JinaAIServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.JinaAiServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.JinaAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}