// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.InferenceResultConverter))]
public sealed partial class InferenceResult
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public InferenceResult()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InferenceResult()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceResult(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.CompletionResult>? Completion { get => GetVariant<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.CompletionResult>>("completion"); set => SetVariant("completion", value); }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.RankedDocument>? Rerank { get => GetVariant<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.RankedDocument>>("rerank"); set => SetVariant("rerank", value); }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult>? SparseEmbedding { get => GetVariant<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult>>("sparse_embedding"); set => SetVariant("sparse_embedding", value); }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult>? TextEmbedding { get => GetVariant<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult>>("text_embedding"); set => SetVariant("text_embedding", value); }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>? TextEmbeddingBits { get => GetVariant<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>>("text_embedding_bits"); set => SetVariant("text_embedding_bits", value); }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>? TextEmbeddingBytes { get => GetVariant<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>>("text_embedding_bytes"); set => SetVariant("text_embedding_bytes", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Inference.InferenceResult(Elastic.Clients.Elasticsearch.Inference.CompletionResult[] value) => new Elastic.Clients.Elasticsearch.Inference.InferenceResult { Completion = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.InferenceResult(Elastic.Clients.Elasticsearch.Inference.RankedDocument[] value) => new Elastic.Clients.Elasticsearch.Inference.InferenceResult { Rerank = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.InferenceResult(Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult[] value) => new Elastic.Clients.Elasticsearch.Inference.InferenceResult { SparseEmbedding = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.InferenceResult(Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult[] value) => new Elastic.Clients.Elasticsearch.Inference.InferenceResult { TextEmbedding = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}