// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class InferenceResultConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.InferenceResult>
{
	private static readonly System.Text.Json.JsonEncodedText VariantCompletion = System.Text.Json.JsonEncodedText.Encode("completion");
	private static readonly System.Text.Json.JsonEncodedText VariantRerank = System.Text.Json.JsonEncodedText.Encode("rerank");
	private static readonly System.Text.Json.JsonEncodedText VariantSparseEmbedding = System.Text.Json.JsonEncodedText.Encode("sparse_embedding");
	private static readonly System.Text.Json.JsonEncodedText VariantTextEmbedding = System.Text.Json.JsonEncodedText.Encode("text_embedding");
	private static readonly System.Text.Json.JsonEncodedText VariantTextEmbeddingBits = System.Text.Json.JsonEncodedText.Encode("text_embedding_bits");
	private static readonly System.Text.Json.JsonEncodedText VariantTextEmbeddingBytes = System.Text.Json.JsonEncodedText.Encode("text_embedding_bytes");

	public override Elastic.Clients.Elasticsearch.Inference.InferenceResult Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantCompletion))
			{
				variantType = VariantCompletion.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.CompletionResult>>(options, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.CompletionResult> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.CompletionResult>(o, null)!);
				continue;
			}

			if (reader.ValueTextEquals(VariantRerank))
			{
				variantType = VariantRerank.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.RankedDocument>>(options, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.RankedDocument> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.RankedDocument>(o, null)!);
				continue;
			}

			if (reader.ValueTextEquals(VariantSparseEmbedding))
			{
				variantType = VariantSparseEmbedding.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult>>(options, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult>(o, null)!);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextEmbedding))
			{
				variantType = VariantTextEmbedding.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult>>(options, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult>(o, null)!);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextEmbeddingBits))
			{
				variantType = VariantTextEmbeddingBits.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>>(options, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>(o, null)!);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextEmbeddingBytes))
			{
				variantType = VariantTextEmbeddingBytes.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>>(options, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>(o, null)!);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.InferenceResult(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.InferenceResult value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "completion":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.CompletionResult>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.CompletionResult> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.CompletionResult>(o, v, null));
				break;
			case "rerank":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.RankedDocument>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.RankedDocument> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.RankedDocument>(o, v, null));
				break;
			case "sparse_embedding":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingResult>(o, v, null));
				break;
			case "text_embedding":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingResult>(o, v, null));
				break;
			case "text_embedding_bits":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>(o, v, null));
				break;
			case "text_embedding_bytes":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingByteResult>(o, v, null));
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Inference.InferenceResult)}'.");
		}

		writer.WriteEndObject();
	}
}