// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// Configuration options when storing the inference endpoint
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.InferenceEndpointConverter))]
public sealed partial class InferenceEndpoint
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceEndpoint(string service, object serviceSettings)
	{
		Service = service;
		ServiceSettings = serviceSettings;
	}
#if NET7_0_OR_GREATER
	public InferenceEndpoint()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public InferenceEndpoint()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceEndpoint(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Chunking configuration object
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? ChunkingSettings { get; set; }

	/// <summary>
	/// <para>
	/// The service type
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Service { get; set; }

	/// <summary>
	/// <para>
	/// Settings specific to the service
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object ServiceSettings { get; set; }

	/// <summary>
	/// <para>
	/// Task settings specific to the service and task type
	/// </para>
	/// </summary>
	public object? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Configuration options when storing the inference endpoint
/// </para>
/// </summary>
public readonly partial struct InferenceEndpointDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceEndpointDescriptor(Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceEndpointDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor(Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint instance) => new Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint(Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Chunking configuration object
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor ChunkingSettings(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? value)
	{
		Instance.ChunkingSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Chunking configuration object
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor ChunkingSettings()
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Chunking configuration object
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor ChunkingSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor>? action)
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The service type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor Service(string value)
	{
		Instance.Service = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings specific to the service
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor ServiceSettings(object value)
	{
		Instance.ServiceSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Task settings specific to the service and task type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor TaskSettings(object? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint Build(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor(new Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}