// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// Chunking configuration object
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.InferenceChunkingSettingsConverter))]
public sealed partial class InferenceChunkingSettings
{
#if NET7_0_OR_GREATER
	public InferenceChunkingSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InferenceChunkingSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceChunkingSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum size of a chunk in words.
	/// This value cannot be higher than <c>300</c> or lower than <c>20</c> (for <c>sentence</c> strategy) or <c>10</c> (for <c>word</c> strategy).
	/// </para>
	/// </summary>
	public int? MaxChunkSize { get; set; }

	/// <summary>
	/// <para>
	/// The number of overlapping words for chunks.
	/// It is applicable only to a <c>word</c> chunking strategy.
	/// This value cannot be higher than half the <c>max_chunk_size</c> value.
	/// </para>
	/// </summary>
	public int? Overlap { get; set; }

	/// <summary>
	/// <para>
	/// The number of overlapping sentences for chunks.
	/// It is applicable only for a <c>sentence</c> chunking strategy.
	/// It can be either <c>1</c> or <c>0</c>.
	/// </para>
	/// </summary>
	public int? SentenceOverlap { get; set; }

	/// <summary>
	/// <para>
	/// Only applicable to the <c>recursive</c> strategy and required when using it.
	/// </para>
	/// <para>
	/// Sets a predefined list of separators in the saved chunking settings based on the selected text type.
	/// Values can be <c>markdown</c> or <c>plaintext</c>.
	/// </para>
	/// <para>
	/// Using this parameter is an alternative to manually specifying a custom <c>separators</c> list.
	/// </para>
	/// </summary>
	public string? SeparatorGroup { get; set; }

	/// <summary>
	/// <para>
	/// Only applicable to the <c>recursive</c> strategy and required when using it.
	/// </para>
	/// <para>
	/// A list of strings used as possible split points when chunking text.
	/// </para>
	/// <para>
	/// Each string can be a plain string or a regular expression (regex) pattern.
	/// The system tries each separator in order to split the text, starting from the first item in the list.
	/// </para>
	/// <para>
	/// After splitting, it attempts to recombine smaller pieces into larger chunks that stay within
	/// the <c>max_chunk_size</c> limit, to reduce the total number of chunks generated.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Separators { get; set; }

	/// <summary>
	/// <para>
	/// The chunking strategy: <c>sentence</c>, <c>word</c>, <c>none</c> or <c>recursive</c>.
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// If <c>strategy</c> is set to <c>recursive</c>, you must also specify:
	/// </para>
	/// </item>
	/// </list>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>max_chunk_size</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// either <c>separators</c> or<c>separator_group</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// Learn more about different chunking strategies in the linked documentation.
	/// </para>
	/// </summary>
	public string? Strategy { get; set; }
}

/// <summary>
/// <para>
/// Chunking configuration object
/// </para>
/// </summary>
public readonly partial struct InferenceChunkingSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceChunkingSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceChunkingSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings instance) => new Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The maximum size of a chunk in words.
	/// This value cannot be higher than <c>300</c> or lower than <c>20</c> (for <c>sentence</c> strategy) or <c>10</c> (for <c>word</c> strategy).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor MaxChunkSize(int? value)
	{
		Instance.MaxChunkSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of overlapping words for chunks.
	/// It is applicable only to a <c>word</c> chunking strategy.
	/// This value cannot be higher than half the <c>max_chunk_size</c> value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor Overlap(int? value)
	{
		Instance.Overlap = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of overlapping sentences for chunks.
	/// It is applicable only for a <c>sentence</c> chunking strategy.
	/// It can be either <c>1</c> or <c>0</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor SentenceOverlap(int? value)
	{
		Instance.SentenceOverlap = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only applicable to the <c>recursive</c> strategy and required when using it.
	/// </para>
	/// <para>
	/// Sets a predefined list of separators in the saved chunking settings based on the selected text type.
	/// Values can be <c>markdown</c> or <c>plaintext</c>.
	/// </para>
	/// <para>
	/// Using this parameter is an alternative to manually specifying a custom <c>separators</c> list.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor SeparatorGroup(string? value)
	{
		Instance.SeparatorGroup = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only applicable to the <c>recursive</c> strategy and required when using it.
	/// </para>
	/// <para>
	/// A list of strings used as possible split points when chunking text.
	/// </para>
	/// <para>
	/// Each string can be a plain string or a regular expression (regex) pattern.
	/// The system tries each separator in order to split the text, starting from the first item in the list.
	/// </para>
	/// <para>
	/// After splitting, it attempts to recombine smaller pieces into larger chunks that stay within
	/// the <c>max_chunk_size</c> limit, to reduce the total number of chunks generated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor Separators(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Separators = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only applicable to the <c>recursive</c> strategy and required when using it.
	/// </para>
	/// <para>
	/// A list of strings used as possible split points when chunking text.
	/// </para>
	/// <para>
	/// Each string can be a plain string or a regular expression (regex) pattern.
	/// The system tries each separator in order to split the text, starting from the first item in the list.
	/// </para>
	/// <para>
	/// After splitting, it attempts to recombine smaller pieces into larger chunks that stay within
	/// the <c>max_chunk_size</c> limit, to reduce the total number of chunks generated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor Separators(params string[] values)
	{
		Instance.Separators = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking strategy: <c>sentence</c>, <c>word</c>, <c>none</c> or <c>recursive</c>.
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// If <c>strategy</c> is set to <c>recursive</c>, you must also specify:
	/// </para>
	/// </item>
	/// </list>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>max_chunk_size</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// either <c>separators</c> or<c>separator_group</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// Learn more about different chunking strategies in the linked documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor Strategy(string? value)
	{
		Instance.Strategy = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}