// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.HuggingFaceTaskSettingsConverter))]
public sealed partial class HuggingFaceTaskSettings
{
#if NET7_0_OR_GREATER
	public HuggingFaceTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public HuggingFaceTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal HuggingFaceTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, return doc text within the results.
	/// </para>
	/// </summary>
	public bool? ReturnDocuments { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of most relevant documents to return.
	/// It defaults to the number of the documents.
	/// </para>
	/// </summary>
	public int? TopN { get; set; }
}

public readonly partial struct HuggingFaceTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HuggingFaceTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HuggingFaceTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings(Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, return doc text within the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettingsDescriptor ReturnDocuments(bool? value = true)
	{
		Instance.ReturnDocuments = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of most relevant documents to return.
	/// It defaults to the number of the documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettingsDescriptor TopN(int? value)
	{
		Instance.TopN = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.HuggingFaceTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}