// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.GoogleVertexAITaskSettingsConverter))]
public sealed partial class GoogleVertexAITaskSettings
{
#if NET7_0_OR_GREATER
	public GoogleVertexAITaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GoogleVertexAITaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GoogleVertexAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, truncate inputs longer than the maximum token length automatically.
	/// </para>
	/// </summary>
	public bool? AutoTruncate { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of the top N documents that should be returned.
	/// </para>
	/// </summary>
	public int? TopN { get; set; }
}

public readonly partial struct GoogleVertexAiTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleVertexAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleVertexAiTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings(Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, truncate inputs longer than the maximum token length automatically.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiTaskSettingsDescriptor AutoTruncate(bool? value = true)
	{
		Instance.AutoTruncate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of the top N documents that should be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiTaskSettingsDescriptor TopN(int? value)
	{
		Instance.TopN = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}