// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.GoogleVertexAIServiceSettingsConverter))]
public sealed partial class GoogleVertexAIServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleVertexAIServiceSettings(string location, string modelId, string projectId, string serviceAccountJson)
	{
		Location = location;
		ModelId = modelId;
		ProjectId = projectId;
		ServiceAccountJson = serviceAccountJson;
	}
#if NET7_0_OR_GREATER
	public GoogleVertexAIServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GoogleVertexAIServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GoogleVertexAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the location to use for the inference task.
	/// Refer to the Google documentation for the list of supported locations.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Location { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Google documentation for the list of supported models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// The name of the project to use for the inference task.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ProjectId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google Vertex AI.
	/// By default, the <c>googlevertexai</c> service sets the number of requests allowed per minute to 30.000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// A valid service account in JSON format for the Google Vertex AI API.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ServiceAccountJson { get; set; }
}

public readonly partial struct GoogleVertexAiServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleVertexAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleVertexAiServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings(Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the location to use for the inference task.
	/// Refer to the Google documentation for the list of supported locations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor Location(string value)
	{
		Instance.Location = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Google documentation for the list of supported models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the project to use for the inference task.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor ProjectId(string value)
	{
		Instance.ProjectId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google Vertex AI.
	/// By default, the <c>googlevertexai</c> service sets the number of requests allowed per minute to 30.000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google Vertex AI.
	/// By default, the <c>googlevertexai</c> service sets the number of requests allowed per minute to 30.000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google Vertex AI.
	/// By default, the <c>googlevertexai</c> service sets the number of requests allowed per minute to 30.000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A valid service account in JSON format for the Google Vertex AI API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor ServiceAccountJson(string value)
	{
		Instance.ServiceAccountJson = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAiServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}