// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class GoogleVertexAIServiceSettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropLocation = System.Text.Json.JsonEncodedText.Encode("location");
	private static readonly System.Text.Json.JsonEncodedText PropModelId = System.Text.Json.JsonEncodedText.Encode("model_id");
	private static readonly System.Text.Json.JsonEncodedText PropProjectId = System.Text.Json.JsonEncodedText.Encode("project_id");
	private static readonly System.Text.Json.JsonEncodedText PropRateLimit = System.Text.Json.JsonEncodedText.Encode("rate_limit");
	private static readonly System.Text.Json.JsonEncodedText PropServiceAccountJson = System.Text.Json.JsonEncodedText.Encode("service_account_json");

	public override Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propLocation = default;
		LocalJsonValue<string> propModelId = default;
		LocalJsonValue<string> propProjectId = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Inference.RateLimitSetting?> propRateLimit = default;
		LocalJsonValue<string> propServiceAccountJson = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propLocation.TryReadProperty(ref reader, options, PropLocation, null))
			{
				continue;
			}

			if (propModelId.TryReadProperty(ref reader, options, PropModelId, null))
			{
				continue;
			}

			if (propProjectId.TryReadProperty(ref reader, options, PropProjectId, null))
			{
				continue;
			}

			if (propRateLimit.TryReadProperty(ref reader, options, PropRateLimit, null))
			{
				continue;
			}

			if (propServiceAccountJson.TryReadProperty(ref reader, options, PropServiceAccountJson, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Location = propLocation.Value,
			ModelId = propModelId.Value,
			ProjectId = propProjectId.Value,
			RateLimit = propRateLimit.Value,
			ServiceAccountJson = propServiceAccountJson.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.GoogleVertexAIServiceSettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropLocation, value.Location, null, null);
		writer.WriteProperty(options, PropModelId, value.ModelId, null, null);
		writer.WriteProperty(options, PropProjectId, value.ProjectId, null, null);
		writer.WriteProperty(options, PropRateLimit, value.RateLimit, null, null);
		writer.WriteProperty(options, PropServiceAccountJson, value.ServiceAccountJson, null, null);
		writer.WriteEndObject();
	}
}