// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.GoogleAiStudioServiceSettingsConverter))]
public sealed partial class GoogleAiStudioServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleAiStudioServiceSettings(string apiKey, string modelId)
	{
		ApiKey = apiKey;
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public GoogleAiStudioServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GoogleAiStudioServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GoogleAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key of your Google Gemini account.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Google documentation for the list of supported models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google AI Studio.
	/// By default, the <c>googleaistudio</c> service sets the number of requests allowed per minute to 360.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }
}

public readonly partial struct GoogleAiStudioServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleAiStudioServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GoogleAiStudioServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key of your Google Gemini account.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Google documentation for the list of supported models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google AI Studio.
	/// By default, the <c>googleaistudio</c> service sets the number of requests allowed per minute to 360.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google AI Studio.
	/// By default, the <c>googleaistudio</c> service sets the number of requests allowed per minute to 360.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Google AI Studio.
	/// By default, the <c>googleaistudio</c> service sets the number of requests allowed per minute to 360.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.GoogleAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}