// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.DeepSeekServiceSettingsConverter))]
public sealed partial class DeepSeekServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeepSeekServiceSettings(string apiKey, string modelId)
	{
		ApiKey = apiKey;
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public DeepSeekServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DeepSeekServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeepSeekServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key for your DeepSeek account.
	/// You can find or create your DeepSeek API keys on the DeepSeek API key page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> or <c>chat_completion</c> task, the name of the model to use for the inference task.
	/// </para>
	/// <para>
	/// For the available <c>completion</c> and <c>chat_completion</c> models, refer to the <a href="https://api-docs.deepseek.com/quick_start/pricing">DeepSeek Models &amp; Pricing docs</a>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// The URL endpoint to use for the requests. Defaults to <c>https://api.deepseek.com/chat/completions</c>.
	/// </para>
	/// </summary>
	public string? Url { get; set; }
}

public readonly partial struct DeepSeekServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeepSeekServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeepSeekServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettings(Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key for your DeepSeek account.
	/// You can find or create your DeepSeek API keys on the DeepSeek API key page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> or <c>chat_completion</c> task, the name of the model to use for the inference task.
	/// </para>
	/// <para>
	/// For the available <c>completion</c> and <c>chat_completion</c> models, refer to the <a href="https://api-docs.deepseek.com/quick_start/pricing">DeepSeek Models &amp; Pricing docs</a>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The URL endpoint to use for the requests. Defaults to <c>https://api.deepseek.com/chat/completions</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor Url(string? value)
	{
		Instance.Url = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.DeepSeekServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}