// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class CustomTaskTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.CustomTaskType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCompletion = System.Text.Json.JsonEncodedText.Encode("completion");
	private static readonly System.Text.Json.JsonEncodedText MemberRerank = System.Text.Json.JsonEncodedText.Encode("rerank");
	private static readonly System.Text.Json.JsonEncodedText MemberSparseEmbedding = System.Text.Json.JsonEncodedText.Encode("sparse_embedding");
	private static readonly System.Text.Json.JsonEncodedText MemberTextEmbedding = System.Text.Json.JsonEncodedText.Encode("text_embedding");

	public override Elastic.Clients.Elasticsearch.Inference.CustomTaskType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCompletion))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.Completion;
		}

		if (reader.ValueTextEquals(MemberRerank))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.Rerank;
		}

		if (reader.ValueTextEquals(MemberSparseEmbedding))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.SparseEmbedding;
		}

		if (reader.ValueTextEquals(MemberTextEmbedding))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.TextEmbedding;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCompletion.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.Completion;
		}

		if (string.Equals(value, MemberRerank.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.Rerank;
		}

		if (string.Equals(value, MemberSparseEmbedding.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.SparseEmbedding;
		}

		if (string.Equals(value, MemberTextEmbedding.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CustomTaskType.TextEmbedding;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CustomTaskType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CustomTaskType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Inference.CustomTaskType.Completion:
				writer.WriteStringValue(MemberCompletion);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CustomTaskType.Rerank:
				writer.WriteStringValue(MemberRerank);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CustomTaskType.SparseEmbedding:
				writer.WriteStringValue(MemberSparseEmbedding);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CustomTaskType.TextEmbedding:
				writer.WriteStringValue(MemberTextEmbedding);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CustomTaskType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Inference.CustomTaskType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CustomTaskType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}