// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CustomTaskSettingsConverter))]
public sealed partial class CustomTaskSettings
{
#if NET7_0_OR_GREATER
	public CustomTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CustomTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CustomTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies parameters that are required to run the custom service. The parameters depend on the model your custom service uses.
	/// For example:
	/// </para>
	/// <code>
	/// "task_settings":{
	///   "parameters":{
	///     "input_type":"query",
	///     "return_token":true
	///   }
	/// }
	/// </code>
	/// </summary>
	public object? Parameters { get; set; }
}

public readonly partial struct CustomTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings(Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies parameters that are required to run the custom service. The parameters depend on the model your custom service uses.
	/// For example:
	/// </para>
	/// <code>
	/// "task_settings":{
	///   "parameters":{
	///     "input_type":"query",
	///     "return_token":true
	///   }
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor Parameters(object? value)
	{
		Instance.Parameters = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}