// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CustomServiceSettingsConverter))]
public sealed partial class CustomServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomServiceSettings(Elastic.Clients.Elasticsearch.Inference.CustomRequestParams request, Elastic.Clients.Elasticsearch.Inference.CustomResponseParams response, object secretParameters)
	{
		Request = request;
		Response = response;
		SecretParameters = secretParameters;
	}
#if NET7_0_OR_GREATER
	public CustomServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CustomServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CustomServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the HTTPS header parameters – such as <c>Authentication</c> or <c>Contet-Type</c> – that are required to access the custom service.
	/// For example:
	/// </para>
	/// <code>
	/// "headers":{
	///   "Authorization": "Bearer ${api_key}",
	///   "Content-Type": "application/json;charset=utf-8"
	/// }
	/// </code>
	/// </summary>
	public object? Headers { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the input type translation values that are used to replace the <c>${input_type}</c> template in the request body.
	/// For example:
	/// </para>
	/// <code>
	/// "input_type": {
	///   "translation": {
	///     "ingest": "do_ingest",
	///     "search": "do_search"
	///   },
	///   "default": "a_default"
	/// },
	/// </code>
	/// <para>
	/// If the subsequent inference requests come from a search context, the <c>search</c> key will be used and the template will be replaced with <c>do_search</c>.
	/// If it comes from the ingest context <c>do_ingest</c> is used. If it's a different context that is not specified, the default value will be used. If no default is specified an empty string is used.
	/// <c>translation</c> can be:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>classification</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>clustering</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ingest</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c>
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public object? InputType { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the query parameters as a list of tuples. The arrays inside the <c>query_parameters</c> must have two items, a key and a value.
	/// For example:
	/// </para>
	/// <code>
	/// "query_parameters":[
	///   ["param_key", "some_value"],
	///   ["param_key", "another_value"],
	///   ["other_key", "other_value"]
	/// ]
	/// </code>
	/// <para>
	/// If the base url is <c>https://www.elastic.co</c> it results in: <c>https://www.elastic.co?param_key=some_value&amp;param_key=another_value&amp;other_key=other_value</c>.
	/// </para>
	/// </summary>
	public object? QueryParameters { get; set; }

	/// <summary>
	/// <para>
	/// The request configuration object.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.CustomRequestParams Request { get; set; }

	/// <summary>
	/// <para>
	/// The response configuration object.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.CustomResponseParams Response { get; set; }

	/// <summary>
	/// <para>
	/// Specifies secret parameters, like <c>api_key</c> or <c>api_token</c>, that are required to access the custom service.
	/// For example:
	/// </para>
	/// <code>
	/// "secret_parameters":{
	///   "api_key":"&lt;api_key>"
	/// }
	/// </code>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object SecretParameters { get; set; }

	/// <summary>
	/// <para>
	/// The URL endpoint to use for the requests.
	/// </para>
	/// </summary>
	public string? Url { get; set; }
}

public readonly partial struct CustomServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings(Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the HTTPS header parameters – such as <c>Authentication</c> or <c>Contet-Type</c> – that are required to access the custom service.
	/// For example:
	/// </para>
	/// <code>
	/// "headers":{
	///   "Authorization": "Bearer ${api_key}",
	///   "Content-Type": "application/json;charset=utf-8"
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor Headers(object? value)
	{
		Instance.Headers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the input type translation values that are used to replace the <c>${input_type}</c> template in the request body.
	/// For example:
	/// </para>
	/// <code>
	/// "input_type": {
	///   "translation": {
	///     "ingest": "do_ingest",
	///     "search": "do_search"
	///   },
	///   "default": "a_default"
	/// },
	/// </code>
	/// <para>
	/// If the subsequent inference requests come from a search context, the <c>search</c> key will be used and the template will be replaced with <c>do_search</c>.
	/// If it comes from the ingest context <c>do_ingest</c> is used. If it's a different context that is not specified, the default value will be used. If no default is specified an empty string is used.
	/// <c>translation</c> can be:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>classification</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>clustering</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ingest</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c>
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor InputType(object? value)
	{
		Instance.InputType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the query parameters as a list of tuples. The arrays inside the <c>query_parameters</c> must have two items, a key and a value.
	/// For example:
	/// </para>
	/// <code>
	/// "query_parameters":[
	///   ["param_key", "some_value"],
	///   ["param_key", "another_value"],
	///   ["other_key", "other_value"]
	/// ]
	/// </code>
	/// <para>
	/// If the base url is <c>https://www.elastic.co</c> it results in: <c>https://www.elastic.co?param_key=some_value&amp;param_key=another_value&amp;other_key=other_value</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor QueryParameters(object? value)
	{
		Instance.QueryParameters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The request configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor Request(Elastic.Clients.Elasticsearch.Inference.CustomRequestParams value)
	{
		Instance.Request = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The request configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor Request(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor> action)
	{
		Instance.Request = Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The response configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor Response(Elastic.Clients.Elasticsearch.Inference.CustomResponseParams value)
	{
		Instance.Response = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The response configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor Response(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor> action)
	{
		Instance.Response = Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies secret parameters, like <c>api_key</c> or <c>api_token</c>, that are required to access the custom service.
	/// For example:
	/// </para>
	/// <code>
	/// "secret_parameters":{
	///   "api_key":"&lt;api_key>"
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor SecretParameters(object value)
	{
		Instance.SecretParameters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The URL endpoint to use for the requests.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor Url(string? value)
	{
		Instance.Url = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}