// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CustomResponseParamsConverter))]
public sealed partial class CustomResponseParams
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomResponseParams(object jsonParser)
	{
		JsonParser = jsonParser;
	}
#if NET7_0_OR_GREATER
	public CustomResponseParams()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CustomResponseParams()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CustomResponseParams(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the JSON parser that is used to parse the response from the custom service.
	/// Different task types require different json_parser parameters.
	/// For example:
	/// </para>
	/// <code>
	/// # text_embedding
	/// # For a response like this:
	/// 
	/// {
	///  "object": "list",
	///  "data": [
	///      {
	///        "object": "embedding",
	///        "index": 0,
	///        "embedding": [
	///            0.014539449,
	///            -0.015288644
	///        ]
	///      }
	///  ],
	///  "model": "text-embedding-ada-002-v2",
	///  "usage": {
	///      "prompt_tokens": 8,
	///      "total_tokens": 8
	///  }
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "text_embeddings":"$.data[*].embedding[*]"
	///   }
	/// }
	/// 
	/// # sparse_embedding
	/// # For a response like this:
	/// 
	/// {
	///   "request_id": "75C50B5B-E79E-4930-****-F48DBB392231",
	///   "latency": 22,
	///   "usage": {
	///      "token_count": 11
	///   },
	///   "result": {
	///      "sparse_embeddings": [
	///         {
	///           "index": 0,
	///           "embedding": [
	///             {
	///               "token_id": 6,
	///               "weight": 0.101
	///             },
	///             {
	///               "token_id": 163040,
	///               "weight": 0.28417
	///             }
	///           ]
	///         }
	///      ]
	///   }
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "token_path":"$.result.sparse_embeddings[*].embedding[*].token_id",
	///     "weight_path":"$.result.sparse_embeddings[*].embedding[*].weight"
	///   }
	/// }
	/// 
	/// # rerank
	/// # For a response like this:
	/// 
	/// {
	///   "results": [
	///     {
	///       "index": 3,
	///       "relevance_score": 0.999071,
	///       "document": "abc"
	///     },
	///     {
	///       "index": 4,
	///       "relevance_score": 0.7867867,
	///       "document": "123"
	///     },
	///     {
	///       "index": 0,
	///       "relevance_score": 0.32713068,
	///       "document": "super"
	///     }
	///   ],
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "reranked_index":"$.result.scores[*].index",    // optional
	///     "relevance_score":"$.result.scores[*].score",
	///     "document_text":"xxx"    // optional
	///   }
	/// }
	/// 
	/// # completion
	/// # For a response like this:
	/// 
	/// {
	///  "id": "chatcmpl-B9MBs8CjcvOU2jLn4n570S5qMJKcT",
	///  "object": "chat.completion",
	///  "created": 1741569952,
	///  "model": "gpt-4.1-2025-04-14",
	///  "choices": [
	///    {
	///     "index": 0,
	///     "message": {
	///       "role": "assistant",
	///       "content": "Hello! How can I assist you today?",
	///       "refusal": null,
	///       "annotations": []
	///     },
	///     "logprobs": null,
	///     "finish_reason": "stop"
	///   }
	///  ]
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "completion_result":"$.choices[*].message.content"
	///   }
	/// }
	/// </code>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object JsonParser { get; set; }
}

public readonly partial struct CustomResponseParamsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CustomResponseParams Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomResponseParamsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomResponseParams instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomResponseParamsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CustomResponseParams(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomResponseParams instance) => new Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CustomResponseParams(Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the JSON parser that is used to parse the response from the custom service.
	/// Different task types require different json_parser parameters.
	/// For example:
	/// </para>
	/// <code>
	/// # text_embedding
	/// # For a response like this:
	/// 
	/// {
	///  "object": "list",
	///  "data": [
	///      {
	///        "object": "embedding",
	///        "index": 0,
	///        "embedding": [
	///            0.014539449,
	///            -0.015288644
	///        ]
	///      }
	///  ],
	///  "model": "text-embedding-ada-002-v2",
	///  "usage": {
	///      "prompt_tokens": 8,
	///      "total_tokens": 8
	///  }
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "text_embeddings":"$.data[*].embedding[*]"
	///   }
	/// }
	/// 
	/// # sparse_embedding
	/// # For a response like this:
	/// 
	/// {
	///   "request_id": "75C50B5B-E79E-4930-****-F48DBB392231",
	///   "latency": 22,
	///   "usage": {
	///      "token_count": 11
	///   },
	///   "result": {
	///      "sparse_embeddings": [
	///         {
	///           "index": 0,
	///           "embedding": [
	///             {
	///               "token_id": 6,
	///               "weight": 0.101
	///             },
	///             {
	///               "token_id": 163040,
	///               "weight": 0.28417
	///             }
	///           ]
	///         }
	///      ]
	///   }
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "token_path":"$.result.sparse_embeddings[*].embedding[*].token_id",
	///     "weight_path":"$.result.sparse_embeddings[*].embedding[*].weight"
	///   }
	/// }
	/// 
	/// # rerank
	/// # For a response like this:
	/// 
	/// {
	///   "results": [
	///     {
	///       "index": 3,
	///       "relevance_score": 0.999071,
	///       "document": "abc"
	///     },
	///     {
	///       "index": 4,
	///       "relevance_score": 0.7867867,
	///       "document": "123"
	///     },
	///     {
	///       "index": 0,
	///       "relevance_score": 0.32713068,
	///       "document": "super"
	///     }
	///   ],
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "reranked_index":"$.result.scores[*].index",    // optional
	///     "relevance_score":"$.result.scores[*].score",
	///     "document_text":"xxx"    // optional
	///   }
	/// }
	/// 
	/// # completion
	/// # For a response like this:
	/// 
	/// {
	///  "id": "chatcmpl-B9MBs8CjcvOU2jLn4n570S5qMJKcT",
	///  "object": "chat.completion",
	///  "created": 1741569952,
	///  "model": "gpt-4.1-2025-04-14",
	///  "choices": [
	///    {
	///     "index": 0,
	///     "message": {
	///       "role": "assistant",
	///       "content": "Hello! How can I assist you today?",
	///       "refusal": null,
	///       "annotations": []
	///     },
	///     "logprobs": null,
	///     "finish_reason": "stop"
	///   }
	///  ]
	/// }
	/// 
	/// # the json_parser definition should look like this:
	/// 
	/// "response":{
	///   "json_parser":{
	///     "completion_result":"$.choices[*].message.content"
	///   }
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor JsonParser(object value)
	{
		Instance.JsonParser = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CustomResponseParams Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.CustomResponseParamsDescriptor(new Elastic.Clients.Elasticsearch.Inference.CustomResponseParams(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}