// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CustomRequestParamsConverter))]
public sealed partial class CustomRequestParams
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomRequestParams(string content)
	{
		Content = content;
	}
#if NET7_0_OR_GREATER
	public CustomRequestParams()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CustomRequestParams()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CustomRequestParams(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The body structure of the request. It requires passing in the string-escaped result of the JSON format HTTP request body.
	/// For example:
	/// </para>
	/// <code>
	/// "request": "{\"input\":${input}}"
	/// </code>
	/// <para>
	/// info
	/// The content string needs to be a single line except when using the Kibana console.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Content { get; set; }
}

public readonly partial struct CustomRequestParamsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CustomRequestParams Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomRequestParamsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomRequestParams instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CustomRequestParamsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CustomRequestParams(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomRequestParams instance) => new Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CustomRequestParams(Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The body structure of the request. It requires passing in the string-escaped result of the JSON format HTTP request body.
	/// For example:
	/// </para>
	/// <code>
	/// "request": "{\"input\":${input}}"
	/// </code>
	/// <para>
	/// info
	/// The content string needs to be a single line except when using the Kibana console.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor Content(string value)
	{
		Instance.Content = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CustomRequestParams Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.CustomRequestParamsDescriptor(new Elastic.Clients.Elasticsearch.Inference.CustomRequestParams(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}