// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// The completion tool function definition.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CompletionToolFunctionConverter))]
public sealed partial class CompletionToolFunction
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionToolFunction(string name)
	{
		Name = name;
	}
#if NET7_0_OR_GREATER
	public CompletionToolFunction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CompletionToolFunction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CompletionToolFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A description of what the function does.
	/// This is used by the model to choose when and how to call the function.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The name of the function.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }

	/// <summary>
	/// <para>
	/// The parameters the functional accepts. This should be formatted as a JSON object.
	/// </para>
	/// </summary>
	public object? Parameters { get; set; }

	/// <summary>
	/// <para>
	/// Whether to enable schema adherence when generating the function call.
	/// </para>
	/// </summary>
	public bool? Strict { get; set; }
}

/// <summary>
/// <para>
/// The completion tool function definition.
/// </para>
/// </summary>
public readonly partial struct CompletionToolFunctionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionToolFunctionDescriptor(Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionToolFunctionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor(Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction instance) => new Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction(Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A description of what the function does.
	/// This is used by the model to choose when and how to call the function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the function.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor Name(string value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The parameters the functional accepts. This should be formatted as a JSON object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor Parameters(object? value)
	{
		Instance.Parameters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to enable schema adherence when generating the function call.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor Strict(bool? value = true)
	{
		Instance.Strict = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor(new Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}