// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// A list of tools that the model can call.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CompletionToolConverter))]
public sealed partial class CompletionTool
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionTool(Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction function, string type)
	{
		Function = function;
		Type = type;
	}
#if NET7_0_OR_GREATER
	public CompletionTool()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CompletionTool()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CompletionTool(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The function definition.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction Function { get; set; }

	/// <summary>
	/// <para>
	/// The type of tool.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Type { get; set; }
}

/// <summary>
/// <para>
/// A list of tools that the model can call.
/// </para>
/// </summary>
public readonly partial struct CompletionToolDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CompletionTool Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionToolDescriptor(Elastic.Clients.Elasticsearch.Inference.CompletionTool instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionToolDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CompletionTool(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor(Elastic.Clients.Elasticsearch.Inference.CompletionTool instance) => new Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CompletionTool(Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The function definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor Function(Elastic.Clients.Elasticsearch.Inference.CompletionToolFunction value)
	{
		Instance.Function = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The function definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor Function(System.Action<Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor> action)
	{
		Instance.Function = Elastic.Clients.Elasticsearch.Inference.CompletionToolFunctionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of tool.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor Type(string value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CompletionTool Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor(new Elastic.Clients.Elasticsearch.Inference.CompletionTool(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}