// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class CohereTruncateTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.CohereTruncateType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberEnd = System.Text.Json.JsonEncodedText.Encode("END");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("NONE");
	private static readonly System.Text.Json.JsonEncodedText MemberStart = System.Text.Json.JsonEncodedText.Encode("START");

	public override Elastic.Clients.Elasticsearch.Inference.CohereTruncateType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberEnd))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.End;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.None;
		}

		if (reader.ValueTextEquals(MemberStart))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.Start;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberEnd.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.End;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.None;
		}

		if (string.Equals(value, MemberStart.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.Start;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CohereTruncateType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CohereTruncateType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.End:
				writer.WriteStringValue(MemberEnd);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.None:
				writer.WriteStringValue(MemberNone);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereTruncateType.Start:
				writer.WriteStringValue(MemberStart);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CohereTruncateType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Inference.CohereTruncateType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CohereTruncateType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}