// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CohereTaskSettingsConverter))]
public sealed partial class CohereTaskSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CohereTaskSettings(Elastic.Clients.Elasticsearch.Inference.CohereInputType inputType)
	{
		InputType = inputType;
	}
#if NET7_0_OR_GREATER
	public CohereTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CohereTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CohereTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the type of input passed to the model.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>classification</c>: Use it for embeddings passed through a text classifier.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>clustering</c>: Use it for the embeddings run through a clustering algorithm.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ingest</c>: Use it for storing document embeddings in a vector database.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c>: Use it for storing embeddings of search queries run against a vector database to find relevant documents.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// IMPORTANT: The <c>input_type</c> field is required when using embedding models <c>v3</c> and higher.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.CohereInputType InputType { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, return doc text within the results.
	/// </para>
	/// </summary>
	public bool? ReturnDocuments { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of most relevant documents to return.
	/// It defaults to the number of the documents.
	/// If this inference endpoint is used in a <c>text_similarity_reranker</c> retriever query and <c>top_n</c> is set, it must be greater than or equal to <c>rank_window_size</c> in the query.
	/// </para>
	/// </summary>
	public int? TopN { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the method to handle inputs longer than the maximum token length.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>END</c>: When the input exceeds the maximum input token length, the end of the input is discarded.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>NONE</c>: When the input exceeds the maximum input token length, an error is returned.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>START</c>: When the input exceeds the maximum input token length, the start of the input is discarded.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereTruncateType? Truncate { get; set; }
}

public readonly partial struct CohereTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CohereTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CohereTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CohereTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CohereTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CohereTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CohereTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CohereTaskSettings(Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the type of input passed to the model.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>classification</c>: Use it for embeddings passed through a text classifier.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>clustering</c>: Use it for the embeddings run through a clustering algorithm.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ingest</c>: Use it for storing document embeddings in a vector database.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c>: Use it for storing embeddings of search queries run against a vector database to find relevant documents.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// IMPORTANT: The <c>input_type</c> field is required when using embedding models <c>v3</c> and higher.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor InputType(Elastic.Clients.Elasticsearch.Inference.CohereInputType value)
	{
		Instance.InputType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, return doc text within the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor ReturnDocuments(bool? value = true)
	{
		Instance.ReturnDocuments = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>rerank</c> task, the number of most relevant documents to return.
	/// It defaults to the number of the documents.
	/// If this inference endpoint is used in a <c>text_similarity_reranker</c> retriever query and <c>top_n</c> is set, it must be greater than or equal to <c>rank_window_size</c> in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor TopN(int? value)
	{
		Instance.TopN = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the method to handle inputs longer than the maximum token length.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>END</c>: When the input exceeds the maximum input token length, the end of the input is discarded.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>NONE</c>: When the input exceeds the maximum input token length, an error is returned.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>START</c>: When the input exceeds the maximum input token length, the start of the input is discarded.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor Truncate(Elastic.Clients.Elasticsearch.Inference.CohereTruncateType? value)
	{
		Instance.Truncate = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CohereTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.CohereTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.CohereTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}