// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class CohereSimilarityTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCosine = System.Text.Json.JsonEncodedText.Encode("cosine");
	private static readonly System.Text.Json.JsonEncodedText MemberDotProduct = System.Text.Json.JsonEncodedText.Encode("dot_product");
	private static readonly System.Text.Json.JsonEncodedText MemberL2Norm = System.Text.Json.JsonEncodedText.Encode("l2_norm");

	public override Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCosine))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.Cosine;
		}

		if (reader.ValueTextEquals(MemberDotProduct))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.DotProduct;
		}

		if (reader.ValueTextEquals(MemberL2Norm))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.L2Norm;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCosine.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.Cosine;
		}

		if (string.Equals(value, MemberDotProduct.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.DotProduct;
		}

		if (string.Equals(value, MemberL2Norm.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.L2Norm;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.Cosine:
				writer.WriteStringValue(MemberCosine);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.DotProduct:
				writer.WriteStringValue(MemberDotProduct);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType.L2Norm:
				writer.WriteStringValue(MemberL2Norm);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}