// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.CohereServiceSettingsConverter))]
public sealed partial class CohereServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CohereServiceSettings(string apiKey, string modelId)
	{
		ApiKey = apiKey;
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public CohereServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CohereServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CohereServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key for your Cohere account.
	/// You can find or create your Cohere API keys on the Cohere API key settings page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the types of embeddings you want to get back.
	/// Use <c>binary</c> for binary embeddings, which are encoded as bytes with signed int8 precision.
	/// Use <c>bit</c> for binary embeddings, which are encoded as bytes with signed int8 precision (this is a synonym of <c>binary</c>).
	/// Use <c>byte</c> for signed int8 embeddings (this is a synonym of <c>int8</c>).
	/// Use <c>float</c> for the default float embeddings.
	/// Use <c>int8</c> for signed int8 embeddings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType? EmbeddingType { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c>, <c>rerank</c>, or <c>text_embedding</c> task, the name of the model to use for the inference task.
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// For the available <c>completion</c> models, refer to the <a href="https://docs.cohere.com/docs/models#command">Cohere command docs</a>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// For the available <c>rerank</c> models, refer to the <a href="https://docs.cohere.com/reference/rerank-1">Cohere rerank docs</a>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// For the available <c>text_embedding</c> models, refer to <a href="https://docs.cohere.com/reference/embed">Cohere embed docs</a>.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Cohere.
	/// By default, the <c>cohere</c> service sets the number of requests allowed per minute to 10000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// The similarity measure.
	/// If the <c>embedding_type</c> is <c>float</c>, the default value is <c>dot_product</c>.
	/// If the <c>embedding_type</c> is <c>int8</c> or <c>byte</c>, the default value is <c>cosine</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType? Similarity { get; set; }
}

public readonly partial struct CohereServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.CohereServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CohereServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CohereServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CohereServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.CohereServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.CohereServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.CohereServiceSettings(Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key for your Cohere account.
	/// You can find or create your Cohere API keys on the Cohere API key settings page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, the types of embeddings you want to get back.
	/// Use <c>binary</c> for binary embeddings, which are encoded as bytes with signed int8 precision.
	/// Use <c>bit</c> for binary embeddings, which are encoded as bytes with signed int8 precision (this is a synonym of <c>binary</c>).
	/// Use <c>byte</c> for signed int8 embeddings (this is a synonym of <c>int8</c>).
	/// Use <c>float</c> for the default float embeddings.
	/// Use <c>int8</c> for signed int8 embeddings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor EmbeddingType(Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType? value)
	{
		Instance.EmbeddingType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c>, <c>rerank</c>, or <c>text_embedding</c> task, the name of the model to use for the inference task.
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// For the available <c>completion</c> models, refer to the <a href="https://docs.cohere.com/docs/models#command">Cohere command docs</a>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// For the available <c>rerank</c> models, refer to the <a href="https://docs.cohere.com/reference/rerank-1">Cohere rerank docs</a>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// For the available <c>text_embedding</c> models, refer to <a href="https://docs.cohere.com/reference/embed">Cohere embed docs</a>.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Cohere.
	/// By default, the <c>cohere</c> service sets the number of requests allowed per minute to 10000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Cohere.
	/// By default, the <c>cohere</c> service sets the number of requests allowed per minute to 10000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Cohere.
	/// By default, the <c>cohere</c> service sets the number of requests allowed per minute to 10000.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The similarity measure.
	/// If the <c>embedding_type</c> is <c>float</c>, the default value is <c>dot_product</c>.
	/// If the <c>embedding_type</c> is <c>int8</c> or <c>byte</c>, the default value is <c>cosine</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor Similarity(Elastic.Clients.Elasticsearch.Inference.CohereSimilarityType? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.CohereServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.CohereServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.CohereServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}