// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class CohereEmbeddingTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBinary = System.Text.Json.JsonEncodedText.Encode("binary");
	private static readonly System.Text.Json.JsonEncodedText MemberBit = System.Text.Json.JsonEncodedText.Encode("bit");
	private static readonly System.Text.Json.JsonEncodedText MemberByte = System.Text.Json.JsonEncodedText.Encode("byte");
	private static readonly System.Text.Json.JsonEncodedText MemberFloat = System.Text.Json.JsonEncodedText.Encode("float");
	private static readonly System.Text.Json.JsonEncodedText MemberInt8 = System.Text.Json.JsonEncodedText.Encode("int8");

	public override Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBinary))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Binary;
		}

		if (reader.ValueTextEquals(MemberBit))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Bit;
		}

		if (reader.ValueTextEquals(MemberByte))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Byte;
		}

		if (reader.ValueTextEquals(MemberFloat))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Float;
		}

		if (reader.ValueTextEquals(MemberInt8))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Int8;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBinary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Binary;
		}

		if (string.Equals(value, MemberBit.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Bit;
		}

		if (string.Equals(value, MemberByte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Byte;
		}

		if (string.Equals(value, MemberFloat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Float;
		}

		if (string.Equals(value, MemberInt8.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Int8;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Binary:
				writer.WriteStringValue(MemberBinary);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Bit:
				writer.WriteStringValue(MemberBit);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Byte:
				writer.WriteStringValue(MemberByte);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Float:
				writer.WriteStringValue(MemberFloat);
				break;
			case Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType.Int8:
				writer.WriteStringValue(MemberInt8);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.CohereEmbeddingType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}