// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AzureOpenAITaskSettingsConverter))]
public sealed partial class AzureOpenAITaskSettings
{
#if NET7_0_OR_GREATER
	public AzureOpenAITaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AzureOpenAITaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AzureOpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> or <c>text_embedding</c> task, specify the user issuing the request.
	/// This information can be used for abuse detection.
	/// </para>
	/// </summary>
	public string? User { get; set; }
}

public readonly partial struct AzureOpenAiTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureOpenAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureOpenAiTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AzureOpenAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AzureOpenAiTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings(Elastic.Clients.Elasticsearch.Inference.AzureOpenAiTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>completion</c> or <c>text_embedding</c> task, specify the user issuing the request.
	/// This information can be used for abuse detection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiTaskSettingsDescriptor User(string? value)
	{
		Instance.User = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AzureOpenAiTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.AzureOpenAiTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AzureOpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}