// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AzureOpenAIServiceSettingsConverter))]
public sealed partial class AzureOpenAIServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureOpenAIServiceSettings(string apiVersion, string deploymentId, string resourceName)
	{
		ApiVersion = apiVersion;
		DeploymentId = deploymentId;
		ResourceName = resourceName;
	}
#if NET7_0_OR_GREATER
	public AzureOpenAIServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AzureOpenAIServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AzureOpenAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key for your Azure OpenAI account.
	/// You must specify either <c>api_key</c> or <c>entra_id</c>.
	/// If you do not provide either or you provide both, you will receive an error when you try to create your model.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public string? ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The Azure API version ID to use.
	/// It is recommended to use the latest supported non-preview version.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiVersion { get; set; }

	/// <summary>
	/// <para>
	/// The deployment name of your deployed models.
	/// Your Azure OpenAI deployments can be found though the Azure OpenAI Studio portal that is linked to your subscription.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string DeploymentId { get; set; }

	/// <summary>
	/// <para>
	/// A valid Microsoft Entra token.
	/// You must specify either <c>api_key</c> or <c>entra_id</c>.
	/// If you do not provide either or you provide both, you will receive an error when you try to create your model.
	/// </para>
	/// </summary>
	public string? EntraId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure.
	/// The <c>azureopenai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>1440</c>.
	/// For <c>completion</c>, it is set to <c>120</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// The name of your Azure OpenAI resource.
	/// You can find this from the list of resources in the Azure Portal for your subscription.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ResourceName { get; set; }
}

public readonly partial struct AzureOpenAiServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureOpenAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureOpenAiServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings(Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key for your Azure OpenAI account.
	/// You must specify either <c>api_key</c> or <c>entra_id</c>.
	/// If you do not provide either or you provide both, you will receive an error when you try to create your model.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor ApiKey(string? value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Azure API version ID to use.
	/// It is recommended to use the latest supported non-preview version.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor ApiVersion(string value)
	{
		Instance.ApiVersion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The deployment name of your deployed models.
	/// Your Azure OpenAI deployments can be found though the Azure OpenAI Studio portal that is linked to your subscription.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor DeploymentId(string value)
	{
		Instance.DeploymentId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A valid Microsoft Entra token.
	/// You must specify either <c>api_key</c> or <c>entra_id</c>.
	/// If you do not provide either or you provide both, you will receive an error when you try to create your model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor EntraId(string? value)
	{
		Instance.EntraId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure.
	/// The <c>azureopenai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>1440</c>.
	/// For <c>completion</c>, it is set to <c>120</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure.
	/// The <c>azureopenai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>1440</c>.
	/// For <c>completion</c>, it is set to <c>120</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure.
	/// The <c>azureopenai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>1440</c>.
	/// For <c>completion</c>, it is set to <c>120</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of your Azure OpenAI resource.
	/// You can find this from the list of resources in the Azure Portal for your subscription.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor ResourceName(string value)
	{
		Instance.ResourceName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.AzureOpenAiServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}