// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class AzureOpenAIServiceSettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropApiKey = System.Text.Json.JsonEncodedText.Encode("api_key");
	private static readonly System.Text.Json.JsonEncodedText PropApiVersion = System.Text.Json.JsonEncodedText.Encode("api_version");
	private static readonly System.Text.Json.JsonEncodedText PropDeploymentId = System.Text.Json.JsonEncodedText.Encode("deployment_id");
	private static readonly System.Text.Json.JsonEncodedText PropEntraId = System.Text.Json.JsonEncodedText.Encode("entra_id");
	private static readonly System.Text.Json.JsonEncodedText PropRateLimit = System.Text.Json.JsonEncodedText.Encode("rate_limit");
	private static readonly System.Text.Json.JsonEncodedText PropResourceName = System.Text.Json.JsonEncodedText.Encode("resource_name");

	public override Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propApiKey = default;
		LocalJsonValue<string> propApiVersion = default;
		LocalJsonValue<string> propDeploymentId = default;
		LocalJsonValue<string?> propEntraId = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Inference.RateLimitSetting?> propRateLimit = default;
		LocalJsonValue<string> propResourceName = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propApiKey.TryReadProperty(ref reader, options, PropApiKey, null))
			{
				continue;
			}

			if (propApiVersion.TryReadProperty(ref reader, options, PropApiVersion, null))
			{
				continue;
			}

			if (propDeploymentId.TryReadProperty(ref reader, options, PropDeploymentId, null))
			{
				continue;
			}

			if (propEntraId.TryReadProperty(ref reader, options, PropEntraId, null))
			{
				continue;
			}

			if (propRateLimit.TryReadProperty(ref reader, options, PropRateLimit, null))
			{
				continue;
			}

			if (propResourceName.TryReadProperty(ref reader, options, PropResourceName, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ApiKey = propApiKey.Value,
			ApiVersion = propApiVersion.Value,
			DeploymentId = propDeploymentId.Value,
			EntraId = propEntraId.Value,
			RateLimit = propRateLimit.Value,
			ResourceName = propResourceName.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.AzureOpenAIServiceSettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropApiKey, value.ApiKey, null, null);
		writer.WriteProperty(options, PropApiVersion, value.ApiVersion, null, null);
		writer.WriteProperty(options, PropDeploymentId, value.DeploymentId, null, null);
		writer.WriteProperty(options, PropEntraId, value.EntraId, null, null);
		writer.WriteProperty(options, PropRateLimit, value.RateLimit, null, null);
		writer.WriteProperty(options, PropResourceName, value.ResourceName, null, null);
		writer.WriteEndObject();
	}
}