// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AzureAiStudioTaskSettingsConverter))]
public sealed partial class AzureAiStudioTaskSettings
{
#if NET7_0_OR_GREATER
	public AzureAiStudioTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AzureAiStudioTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AzureAiStudioTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, instruct the inference process to perform sampling.
	/// It has no effect unless <c>temperature</c> or <c>top_p</c> is specified.
	/// </para>
	/// </summary>
	public float? DoSample { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, provide a hint for the maximum number of output tokens to be generated.
	/// </para>
	/// </summary>
	public int? MaxNewTokens { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, control the apparent creativity of generated completions with a sampling temperature.
	/// It must be a number in the range of 0.0 to 2.0.
	/// It should not be used if <c>top_p</c> is specified.
	/// </para>
	/// </summary>
	public float? Temperature { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, make the model consider the results of the tokens with nucleus sampling probability.
	/// It is an alternative value to <c>temperature</c> and must be a number in the range of 0.0 to 2.0.
	/// It should not be used if <c>temperature</c> is specified.
	/// </para>
	/// </summary>
	public float? TopP { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, specify the user issuing the request.
	/// This information can be used for abuse detection.
	/// </para>
	/// </summary>
	public string? User { get; set; }
}

public readonly partial struct AzureAiStudioTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureAiStudioTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureAiStudioTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, instruct the inference process to perform sampling.
	/// It has no effect unless <c>temperature</c> or <c>top_p</c> is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor DoSample(float? value)
	{
		Instance.DoSample = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, provide a hint for the maximum number of output tokens to be generated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor MaxNewTokens(int? value)
	{
		Instance.MaxNewTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, control the apparent creativity of generated completions with a sampling temperature.
	/// It must be a number in the range of 0.0 to 2.0.
	/// It should not be used if <c>top_p</c> is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor Temperature(float? value)
	{
		Instance.Temperature = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, make the model consider the results of the tokens with nucleus sampling probability.
	/// It is an alternative value to <c>temperature</c> and must be a number in the range of 0.0 to 2.0.
	/// It should not be used if <c>temperature</c> is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor TopP(float? value)
	{
		Instance.TopP = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>text_embedding</c> task, specify the user issuing the request.
	/// This information can be used for abuse detection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor User(string? value)
	{
		Instance.User = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}