// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AzureAiStudioServiceSettingsConverter))]
public sealed partial class AzureAiStudioServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureAiStudioServiceSettings(string apiKey, string endpointType, string provider, string target)
	{
		ApiKey = apiKey;
		EndpointType = endpointType;
		Provider = provider;
		Target = target;
	}
#if NET7_0_OR_GREATER
	public AzureAiStudioServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AzureAiStudioServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AzureAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key of your Azure AI Studio model deployment.
	/// This key can be found on the overview page for your deployment in the management section of your Azure AI Studio account.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The type of endpoint that is available for deployment through Azure AI Studio: <c>token</c> or <c>realtime</c>.
	/// The <c>token</c> endpoint type is for "pay as you go" endpoints that are billed per token.
	/// The <c>realtime</c> endpoint type is for "real-time" endpoints that are billed per hour of usage.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string EndpointType { get; set; }

	/// <summary>
	/// <para>
	/// The model provider for your deployment.
	/// Note that some providers may support only certain task types.
	/// Supported providers include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>cohere</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>databricks</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>meta</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>microsoft_phi</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>mistral</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>openai</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Provider { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure AI Studio.
	/// By default, the <c>azureaistudio</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// The target URL of your Azure AI Studio model deployment.
	/// This can be found on the overview page for your deployment in the management section of your Azure AI Studio account.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Target { get; set; }
}

public readonly partial struct AzureAiStudioServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureAiStudioServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureAiStudioServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key of your Azure AI Studio model deployment.
	/// This key can be found on the overview page for your deployment in the management section of your Azure AI Studio account.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of endpoint that is available for deployment through Azure AI Studio: <c>token</c> or <c>realtime</c>.
	/// The <c>token</c> endpoint type is for "pay as you go" endpoints that are billed per token.
	/// The <c>realtime</c> endpoint type is for "real-time" endpoints that are billed per hour of usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor EndpointType(string value)
	{
		Instance.EndpointType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The model provider for your deployment.
	/// Note that some providers may support only certain task types.
	/// Supported providers include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>cohere</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>databricks</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>meta</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>microsoft_phi</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>mistral</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>openai</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor Provider(string value)
	{
		Instance.Provider = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure AI Studio.
	/// By default, the <c>azureaistudio</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure AI Studio.
	/// By default, the <c>azureaistudio</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Azure AI Studio.
	/// By default, the <c>azureaistudio</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The target URL of your Azure AI Studio model deployment.
	/// This can be found on the overview page for your deployment in the management section of your Azure AI Studio account.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor Target(string value)
	{
		Instance.Target = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}