// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AnthropicTaskSettingsConverter))]
public sealed partial class AnthropicTaskSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnthropicTaskSettings(int maxTokens)
	{
		MaxTokens = maxTokens;
	}
#if NET7_0_OR_GREATER
	public AnthropicTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AnthropicTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AnthropicTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is the maximum number of tokens to generate before stopping.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MaxTokens { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is the amount of randomness injected into the response.
	/// For more details about the supported range, refer to Anthropic documentation.
	/// </para>
	/// </summary>
	public float? Temperature { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it specifies to only sample from the top K options for each subsequent token.
	/// It is recommended for advanced use cases only.
	/// You usually only need to use <c>temperature</c>.
	/// </para>
	/// </summary>
	public int? TopK { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it specifies to use Anthropic's nucleus sampling.
	/// In nucleus sampling, Anthropic computes the cumulative distribution over all the options for each subsequent token in decreasing probability order and cuts it off once it reaches the specified probability.
	/// You should either alter <c>temperature</c> or <c>top_p</c>, but not both.
	/// It is recommended for advanced use cases only.
	/// You usually only need to use <c>temperature</c>.
	/// </para>
	/// </summary>
	public float? TopP { get; set; }
}

public readonly partial struct AnthropicTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnthropicTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnthropicTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettings(Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is the maximum number of tokens to generate before stopping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor MaxTokens(int value)
	{
		Instance.MaxTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is the amount of randomness injected into the response.
	/// For more details about the supported range, refer to Anthropic documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor Temperature(float? value)
	{
		Instance.Temperature = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it specifies to only sample from the top K options for each subsequent token.
	/// It is recommended for advanced use cases only.
	/// You usually only need to use <c>temperature</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor TopK(int? value)
	{
		Instance.TopK = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it specifies to use Anthropic's nucleus sampling.
	/// In nucleus sampling, Anthropic computes the cumulative distribution over all the options for each subsequent token in decreasing probability order and cuts it off once it reaches the specified probability.
	/// You should either alter <c>temperature</c> or <c>top_p</c>, but not both.
	/// It is recommended for advanced use cases only.
	/// You usually only need to use <c>temperature</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor TopP(float? value)
	{
		Instance.TopP = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AnthropicTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}