// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AnthropicServiceSettingsConverter))]
public sealed partial class AnthropicServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnthropicServiceSettings(string apiKey, string modelId)
	{
		ApiKey = apiKey;
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public AnthropicServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AnthropicServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AnthropicServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key for the Anthropic API.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Anthropic documentation for the list of supported models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Anthropic.
	/// By default, the <c>anthropic</c> service sets the number of requests allowed per minute to 50.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }
}

public readonly partial struct AnthropicServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnthropicServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnthropicServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettings(Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key for the Anthropic API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Anthropic documentation for the list of supported models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Anthropic.
	/// By default, the <c>anthropic</c> service sets the number of requests allowed per minute to 50.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Anthropic.
	/// By default, the <c>anthropic</c> service sets the number of requests allowed per minute to 50.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Anthropic.
	/// By default, the <c>anthropic</c> service sets the number of requests allowed per minute to 50.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AnthropicServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}