// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AmazonSageMakerTaskSettingsConverter))]
public sealed partial class AmazonSageMakerTaskSettings
{
#if NET7_0_OR_GREATER
	public AmazonSageMakerTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AmazonSageMakerTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AmazonSageMakerTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The AWS custom attributes passed verbatim through to the model running in the SageMaker Endpoint.
	/// Values will be returned in the <c>X-elastic-sagemaker-custom-attributes</c> header.
	/// </para>
	/// </summary>
	public string? CustomAttributes { get; set; }

	/// <summary>
	/// <para>
	/// The optional JMESPath expression used to override the EnableExplanations provided during endpoint creation.
	/// </para>
	/// </summary>
	public string? EnableExplanations { get; set; }

	/// <summary>
	/// <para>
	/// The capture data ID when enabled in the endpoint.
	/// </para>
	/// </summary>
	public string? InferenceId { get; set; }

	/// <summary>
	/// <para>
	/// The stateful session identifier for a new or existing session.
	/// New sessions will be returned in the <c>X-elastic-sagemaker-new-session-id</c> header.
	/// Closed sessions will be returned in the <c>X-elastic-sagemaker-closed-session-id</c> header.
	/// </para>
	/// </summary>
	public string? SessionId { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the variant when running with multi-variant Endpoints.
	/// </para>
	/// </summary>
	public string? TargetVariant { get; set; }
}

public readonly partial struct AmazonSageMakerTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonSageMakerTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonSageMakerTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The AWS custom attributes passed verbatim through to the model running in the SageMaker Endpoint.
	/// Values will be returned in the <c>X-elastic-sagemaker-custom-attributes</c> header.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor CustomAttributes(string? value)
	{
		Instance.CustomAttributes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The optional JMESPath expression used to override the EnableExplanations provided during endpoint creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor EnableExplanations(string? value)
	{
		Instance.EnableExplanations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The capture data ID when enabled in the endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor InferenceId(string? value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The stateful session identifier for a new or existing session.
	/// New sessions will be returned in the <c>X-elastic-sagemaker-new-session-id</c> header.
	/// Closed sessions will be returned in the <c>X-elastic-sagemaker-closed-session-id</c> header.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor SessionId(string? value)
	{
		Instance.SessionId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the variant when running with multi-variant Endpoints.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor TargetVariant(string? value)
	{
		Instance.TargetVariant = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}