// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class AmazonSageMakerTaskSettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropCustomAttributes = System.Text.Json.JsonEncodedText.Encode("custom_attributes");
	private static readonly System.Text.Json.JsonEncodedText PropEnableExplanations = System.Text.Json.JsonEncodedText.Encode("enable_explanations");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceId = System.Text.Json.JsonEncodedText.Encode("inference_id");
	private static readonly System.Text.Json.JsonEncodedText PropSessionId = System.Text.Json.JsonEncodedText.Encode("session_id");
	private static readonly System.Text.Json.JsonEncodedText PropTargetVariant = System.Text.Json.JsonEncodedText.Encode("target_variant");

	public override Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propCustomAttributes = default;
		LocalJsonValue<string?> propEnableExplanations = default;
		LocalJsonValue<string?> propInferenceId = default;
		LocalJsonValue<string?> propSessionId = default;
		LocalJsonValue<string?> propTargetVariant = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCustomAttributes.TryReadProperty(ref reader, options, PropCustomAttributes, null))
			{
				continue;
			}

			if (propEnableExplanations.TryReadProperty(ref reader, options, PropEnableExplanations, null))
			{
				continue;
			}

			if (propInferenceId.TryReadProperty(ref reader, options, PropInferenceId, null))
			{
				continue;
			}

			if (propSessionId.TryReadProperty(ref reader, options, PropSessionId, null))
			{
				continue;
			}

			if (propTargetVariant.TryReadProperty(ref reader, options, PropTargetVariant, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			CustomAttributes = propCustomAttributes.Value,
			EnableExplanations = propEnableExplanations.Value,
			InferenceId = propInferenceId.Value,
			SessionId = propSessionId.Value,
			TargetVariant = propTargetVariant.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCustomAttributes, value.CustomAttributes, null, null);
		writer.WriteProperty(options, PropEnableExplanations, value.EnableExplanations, null, null);
		writer.WriteProperty(options, PropInferenceId, value.InferenceId, null, null);
		writer.WriteProperty(options, PropSessionId, value.SessionId, null, null);
		writer.WriteProperty(options, PropTargetVariant, value.TargetVariant, null, null);
		writer.WriteEndObject();
	}
}