// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AmazonSageMakerServiceSettingsConverter))]
public sealed partial class AmazonSageMakerServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonSageMakerServiceSettings(string accessKey, Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi api, string endpointName, string region, string secretKey)
	{
		AccessKey = accessKey;
		Api = api;
		EndpointName = endpointName;
		Region = region;
		SecretKey = secretKey;
	}
#if NET7_0_OR_GREATER
	public AmazonSageMakerServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AmazonSageMakerServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AmazonSageMakerServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid AWS access key that has permissions to use Amazon SageMaker and access to models for invoking requests.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string AccessKey { get; set; }

	/// <summary>
	/// <para>
	/// The API format to use when calling SageMaker.
	/// Elasticsearch will convert the POST _inference request to this data format when invoking the SageMaker endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi Api { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of inputs in each batch. This value is used by inference ingestion pipelines
	/// when processing semantic values. It correlates to the number of times the SageMaker endpoint is
	/// invoked (one per batch of input).
	/// </para>
	/// </summary>
	public int? BatchSize { get; set; }

	/// <summary>
	/// <para>
	/// The number of dimensions returned by the text embedding models. If this value is not provided, then
	/// it is guessed by making invoking the endpoint for the <c>text_embedding</c> task.
	/// </para>
	/// </summary>
	public int? Dimensions { get; set; }

	/// <summary>
	/// <para>
	/// The name of the SageMaker endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string EndpointName { get; set; }

	/// <summary>
	/// <para>
	/// The inference component to directly invoke when calling a multi-component endpoint.
	/// </para>
	/// </summary>
	public string? InferenceComponentName { get; set; }

	/// <summary>
	/// <para>
	/// The region that your endpoint or Amazon Resource Name (ARN) is deployed in.
	/// The list of available regions per model can be found in the Amazon SageMaker documentation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Region { get; set; }

	/// <summary>
	/// <para>
	/// A valid AWS secret key that is paired with the <c>access_key</c>.
	/// For information about creating and managing access and secret keys, refer to the AWS documentation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string SecretKey { get; set; }

	/// <summary>
	/// <para>
	/// The container to directly invoke when calling a multi-container endpoint.
	/// </para>
	/// </summary>
	public string? TargetContainerHostname { get; set; }

	/// <summary>
	/// <para>
	/// The model ID when calling a multi-model endpoint.
	/// </para>
	/// </summary>
	public string? TargetModel { get; set; }
}

public readonly partial struct AmazonSageMakerServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonSageMakerServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonSageMakerServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid AWS access key that has permissions to use Amazon SageMaker and access to models for invoking requests.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor AccessKey(string value)
	{
		Instance.AccessKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The API format to use when calling SageMaker.
	/// Elasticsearch will convert the POST _inference request to this data format when invoking the SageMaker endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor Api(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi value)
	{
		Instance.Api = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of inputs in each batch. This value is used by inference ingestion pipelines
	/// when processing semantic values. It correlates to the number of times the SageMaker endpoint is
	/// invoked (one per batch of input).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor BatchSize(int? value)
	{
		Instance.BatchSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of dimensions returned by the text embedding models. If this value is not provided, then
	/// it is guessed by making invoking the endpoint for the <c>text_embedding</c> task.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor Dimensions(int? value)
	{
		Instance.Dimensions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the SageMaker endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor EndpointName(string value)
	{
		Instance.EndpointName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The inference component to directly invoke when calling a multi-component endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor InferenceComponentName(string? value)
	{
		Instance.InferenceComponentName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The region that your endpoint or Amazon Resource Name (ARN) is deployed in.
	/// The list of available regions per model can be found in the Amazon SageMaker documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor Region(string value)
	{
		Instance.Region = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A valid AWS secret key that is paired with the <c>access_key</c>.
	/// For information about creating and managing access and secret keys, refer to the AWS documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor SecretKey(string value)
	{
		Instance.SecretKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The container to directly invoke when calling a multi-container endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor TargetContainerHostname(string? value)
	{
		Instance.TargetContainerHostname = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The model ID when calling a multi-model endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor TargetModel(string? value)
	{
		Instance.TargetModel = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}