// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class AmazonSageMakerServiceSettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropAccessKey = System.Text.Json.JsonEncodedText.Encode("access_key");
	private static readonly System.Text.Json.JsonEncodedText PropApi = System.Text.Json.JsonEncodedText.Encode("api");
	private static readonly System.Text.Json.JsonEncodedText PropBatchSize = System.Text.Json.JsonEncodedText.Encode("batch_size");
	private static readonly System.Text.Json.JsonEncodedText PropDimensions = System.Text.Json.JsonEncodedText.Encode("dimensions");
	private static readonly System.Text.Json.JsonEncodedText PropEndpointName = System.Text.Json.JsonEncodedText.Encode("endpoint_name");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceComponentName = System.Text.Json.JsonEncodedText.Encode("inference_component_name");
	private static readonly System.Text.Json.JsonEncodedText PropRegion = System.Text.Json.JsonEncodedText.Encode("region");
	private static readonly System.Text.Json.JsonEncodedText PropSecretKey = System.Text.Json.JsonEncodedText.Encode("secret_key");
	private static readonly System.Text.Json.JsonEncodedText PropTargetContainerHostname = System.Text.Json.JsonEncodedText.Encode("target_container_hostname");
	private static readonly System.Text.Json.JsonEncodedText PropTargetModel = System.Text.Json.JsonEncodedText.Encode("target_model");

	public override Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propAccessKey = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi> propApi = default;
		LocalJsonValue<int?> propBatchSize = default;
		LocalJsonValue<int?> propDimensions = default;
		LocalJsonValue<string> propEndpointName = default;
		LocalJsonValue<string?> propInferenceComponentName = default;
		LocalJsonValue<string> propRegion = default;
		LocalJsonValue<string> propSecretKey = default;
		LocalJsonValue<string?> propTargetContainerHostname = default;
		LocalJsonValue<string?> propTargetModel = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAccessKey.TryReadProperty(ref reader, options, PropAccessKey, null))
			{
				continue;
			}

			if (propApi.TryReadProperty(ref reader, options, PropApi, null))
			{
				continue;
			}

			if (propBatchSize.TryReadProperty(ref reader, options, PropBatchSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propDimensions.TryReadProperty(ref reader, options, PropDimensions, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propEndpointName.TryReadProperty(ref reader, options, PropEndpointName, null))
			{
				continue;
			}

			if (propInferenceComponentName.TryReadProperty(ref reader, options, PropInferenceComponentName, null))
			{
				continue;
			}

			if (propRegion.TryReadProperty(ref reader, options, PropRegion, null))
			{
				continue;
			}

			if (propSecretKey.TryReadProperty(ref reader, options, PropSecretKey, null))
			{
				continue;
			}

			if (propTargetContainerHostname.TryReadProperty(ref reader, options, PropTargetContainerHostname, null))
			{
				continue;
			}

			if (propTargetModel.TryReadProperty(ref reader, options, PropTargetModel, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AccessKey = propAccessKey.Value,
			Api = propApi.Value,
			BatchSize = propBatchSize.Value,
			Dimensions = propDimensions.Value,
			EndpointName = propEndpointName.Value,
			InferenceComponentName = propInferenceComponentName.Value,
			Region = propRegion.Value,
			SecretKey = propSecretKey.Value,
			TargetContainerHostname = propTargetContainerHostname.Value,
			TargetModel = propTargetModel.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAccessKey, value.AccessKey, null, null);
		writer.WriteProperty(options, PropApi, value.Api, null, null);
		writer.WriteProperty(options, PropBatchSize, value.BatchSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropDimensions, value.Dimensions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropEndpointName, value.EndpointName, null, null);
		writer.WriteProperty(options, PropInferenceComponentName, value.InferenceComponentName, null, null);
		writer.WriteProperty(options, PropRegion, value.Region, null, null);
		writer.WriteProperty(options, PropSecretKey, value.SecretKey, null, null);
		writer.WriteProperty(options, PropTargetContainerHostname, value.TargetContainerHostname, null, null);
		writer.WriteProperty(options, PropTargetModel, value.TargetModel, null, null);
		writer.WriteEndObject();
	}
}