// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class AmazonSageMakerApiConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi>
{
	private static readonly System.Text.Json.JsonEncodedText MemberElastic = System.Text.Json.JsonEncodedText.Encode("elastic");
	private static readonly System.Text.Json.JsonEncodedText MemberOpenai = System.Text.Json.JsonEncodedText.Encode("openai");

	public override Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberElastic))
		{
			return Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi.Elastic;
		}

		if (reader.ValueTextEquals(MemberOpenai))
		{
			return Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi.Openai;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberElastic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi.Elastic;
		}

		if (string.Equals(value, MemberOpenai.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi.Openai;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi.Elastic:
				writer.WriteStringValue(MemberElastic);
				break;
			case Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi.Openai:
				writer.WriteStringValue(MemberOpenai);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerApi value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}