// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AmazonBedrockTaskSettingsConverter))]
public sealed partial class AmazonBedrockTaskSettings
{
#if NET7_0_OR_GREATER
	public AmazonBedrockTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AmazonBedrockTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AmazonBedrockTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it sets the maximum number for the output tokens to be generated.
	/// </para>
	/// </summary>
	public int? MaxNewTokens { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is a number between 0.0 and 1.0 that controls the apparent creativity of the results.
	/// At temperature 0.0 the model is most deterministic, at temperature 1.0 most random.
	/// It should not be used if <c>top_p</c> or <c>top_k</c> is specified.
	/// </para>
	/// </summary>
	public float? Temperature { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it limits samples to the top-K most likely words, balancing coherence and variability.
	/// It is only available for anthropic, cohere, and mistral providers.
	/// It is an alternative to <c>temperature</c>; it should not be used if <c>temperature</c> is specified.
	/// </para>
	/// </summary>
	public float? TopK { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is a number in the range of 0.0 to 1.0, to eliminate low-probability tokens.
	/// Top-p uses nucleus sampling to select top tokens whose sum of likelihoods does not exceed a certain value, ensuring both variety and coherence.
	/// It is an alternative to <c>temperature</c>; it should not be used if <c>temperature</c> is specified.
	/// </para>
	/// </summary>
	public float? TopP { get; set; }
}

public readonly partial struct AmazonBedrockTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonBedrockTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonBedrockTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings(Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it sets the maximum number for the output tokens to be generated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor MaxNewTokens(int? value)
	{
		Instance.MaxNewTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is a number between 0.0 and 1.0 that controls the apparent creativity of the results.
	/// At temperature 0.0 the model is most deterministic, at temperature 1.0 most random.
	/// It should not be used if <c>top_p</c> or <c>top_k</c> is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor Temperature(float? value)
	{
		Instance.Temperature = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it limits samples to the top-K most likely words, balancing coherence and variability.
	/// It is only available for anthropic, cohere, and mistral providers.
	/// It is an alternative to <c>temperature</c>; it should not be used if <c>temperature</c> is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor TopK(float? value)
	{
		Instance.TopK = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> task, it is a number in the range of 0.0 to 1.0, to eliminate low-probability tokens.
	/// Top-p uses nucleus sampling to select top tokens whose sum of likelihoods does not exceed a certain value, ensuring both variety and coherence.
	/// It is an alternative to <c>temperature</c>; it should not be used if <c>temperature</c> is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor TopP(float? value)
	{
		Instance.TopP = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}