// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AmazonBedrockServiceSettingsConverter))]
public sealed partial class AmazonBedrockServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonBedrockServiceSettings(string accessKey, string model, string region, string secretKey)
	{
		AccessKey = accessKey;
		Model = model;
		Region = region;
		SecretKey = secretKey;
	}
#if NET7_0_OR_GREATER
	public AmazonBedrockServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AmazonBedrockServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AmazonBedrockServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid AWS access key that has permissions to use Amazon Bedrock and access to models for inference requests.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string AccessKey { get; set; }

	/// <summary>
	/// <para>
	/// The base model ID or an ARN to a custom model based on a foundational model.
	/// The base model IDs can be found in the Amazon Bedrock documentation.
	/// Note that the model ID must be available for the provider chosen and your IAM user must have access to the model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Model { get; set; }

	/// <summary>
	/// <para>
	/// The model provider for your deployment.
	/// Note that some providers may support only certain task types.
	/// Supported providers include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>amazontitan</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>anthropic</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ai21labs</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>cohere</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>meta</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>mistral</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public string? Provider { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// The region that your model or ARN is deployed in.
	/// The list of available regions per model can be found in the Amazon Bedrock documentation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Region { get; set; }

	/// <summary>
	/// <para>
	/// A valid AWS secret key that is paired with the <c>access_key</c>.
	/// For informationg about creating and managing access and secret keys, refer to the AWS documentation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string SecretKey { get; set; }
}

public readonly partial struct AmazonBedrockServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonBedrockServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AmazonBedrockServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings(Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid AWS access key that has permissions to use Amazon Bedrock and access to models for inference requests.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor AccessKey(string value)
	{
		Instance.AccessKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The base model ID or an ARN to a custom model based on a foundational model.
	/// The base model IDs can be found in the Amazon Bedrock documentation.
	/// Note that the model ID must be available for the provider chosen and your IAM user must have access to the model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor Model(string value)
	{
		Instance.Model = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The model provider for your deployment.
	/// Note that some providers may support only certain task types.
	/// Supported providers include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>amazontitan</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>anthropic</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>ai21labs</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>cohere</c> - available for <c>text_embedding</c> and <c>completion</c> task types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>meta</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>mistral</c> - available for <c>completion</c> task type only
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor Provider(string? value)
	{
		Instance.Provider = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The region that your model or ARN is deployed in.
	/// The list of available regions per model can be found in the Amazon Bedrock documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor Region(string value)
	{
		Instance.Region = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A valid AWS secret key that is paired with the <c>access_key</c>.
	/// For informationg about creating and managing access and secret keys, refer to the AWS documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor SecretKey(string value)
	{
		Instance.SecretKey = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}