// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class AmazonBedrockServiceSettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropAccessKey = System.Text.Json.JsonEncodedText.Encode("access_key");
	private static readonly System.Text.Json.JsonEncodedText PropModel = System.Text.Json.JsonEncodedText.Encode("model");
	private static readonly System.Text.Json.JsonEncodedText PropProvider = System.Text.Json.JsonEncodedText.Encode("provider");
	private static readonly System.Text.Json.JsonEncodedText PropRateLimit = System.Text.Json.JsonEncodedText.Encode("rate_limit");
	private static readonly System.Text.Json.JsonEncodedText PropRegion = System.Text.Json.JsonEncodedText.Encode("region");
	private static readonly System.Text.Json.JsonEncodedText PropSecretKey = System.Text.Json.JsonEncodedText.Encode("secret_key");

	public override Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propAccessKey = default;
		LocalJsonValue<string> propModel = default;
		LocalJsonValue<string?> propProvider = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Inference.RateLimitSetting?> propRateLimit = default;
		LocalJsonValue<string> propRegion = default;
		LocalJsonValue<string> propSecretKey = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAccessKey.TryReadProperty(ref reader, options, PropAccessKey, null))
			{
				continue;
			}

			if (propModel.TryReadProperty(ref reader, options, PropModel, null))
			{
				continue;
			}

			if (propProvider.TryReadProperty(ref reader, options, PropProvider, null))
			{
				continue;
			}

			if (propRateLimit.TryReadProperty(ref reader, options, PropRateLimit, null))
			{
				continue;
			}

			if (propRegion.TryReadProperty(ref reader, options, PropRegion, null))
			{
				continue;
			}

			if (propSecretKey.TryReadProperty(ref reader, options, PropSecretKey, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AccessKey = propAccessKey.Value,
			Model = propModel.Value,
			Provider = propProvider.Value,
			RateLimit = propRateLimit.Value,
			Region = propRegion.Value,
			SecretKey = propSecretKey.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.AmazonBedrockServiceSettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAccessKey, value.AccessKey, null, null);
		writer.WriteProperty(options, PropModel, value.Model, null, null);
		writer.WriteProperty(options, PropProvider, value.Provider, null, null);
		writer.WriteProperty(options, PropRateLimit, value.RateLimit, null, null);
		writer.WriteProperty(options, PropRegion, value.Region, null, null);
		writer.WriteProperty(options, PropSecretKey, value.SecretKey, null, null);
		writer.WriteEndObject();
	}
}