// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AlibabaCloudTaskSettingsConverter))]
public sealed partial class AlibabaCloudTaskSettings
{
#if NET7_0_OR_GREATER
	public AlibabaCloudTaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AlibabaCloudTaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AlibabaCloudTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>sparse_embedding</c> or <c>text_embedding</c> task, specify the type of input passed to the model.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ingest</c> for storing document embeddings in a vector database.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c> for storing embeddings of search queries run against a vector database to find relevant documents.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public string? InputType { get; set; }

	/// <summary>
	/// <para>
	/// For a <c>sparse_embedding</c> task, it affects whether the token name will be returned in the response.
	/// It defaults to <c>false</c>, which means only the token ID will be returned in the response.
	/// </para>
	/// </summary>
	public bool? ReturnToken { get; set; }
}

public readonly partial struct AlibabaCloudTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AlibabaCloudTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AlibabaCloudTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>sparse_embedding</c> or <c>text_embedding</c> task, specify the type of input passed to the model.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ingest</c> for storing document embeddings in a vector database.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>search</c> for storing embeddings of search queries run against a vector database to find relevant documents.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor InputType(string? value)
	{
		Instance.InputType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a <c>sparse_embedding</c> task, it affects whether the token name will be returned in the response.
	/// It defaults to <c>false</c>, which means only the token ID will be returned in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor ReturnToken(bool? value = true)
	{
		Instance.ReturnToken = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}