// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AlibabaCloudServiceSettingsConverter))]
public sealed partial class AlibabaCloudServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AlibabaCloudServiceSettings(string apiKey, string host, string serviceId, string workspace)
	{
		ApiKey = apiKey;
		Host = host;
		ServiceId = serviceId;
		Workspace = workspace;
	}
#if NET7_0_OR_GREATER
	public AlibabaCloudServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AlibabaCloudServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AlibabaCloudServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key for the AlibabaCloud AI Search API.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The name of the host address used for the inference task.
	/// You can find the host address in the API keys section of the documentation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Host { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from AlibabaCloud AI Search.
	/// By default, the <c>alibabacloud-ai-search</c> service sets the number of requests allowed per minute to <c>1000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model service to use for the inference task.
	/// The following service IDs are available for the <c>completion</c> task:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ops-qwen-turbo</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>qwen-turbo</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>qwen-plus</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>qwen-max ÷ qwen-max-longcontext</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The following service ID is available for the <c>rerank</c> task:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ops-bge-reranker-larger</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The following service ID is available for the <c>sparse_embedding</c> task:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ops-text-sparse-embedding-001</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The following service IDs are available for the <c>text_embedding</c> task:
	/// </para>
	/// <para>
	/// <c>ops-text-embedding-001</c>
	/// <c>ops-text-embedding-zh-001</c>
	/// <c>ops-text-embedding-en-001</c>
	/// <c>ops-text-embedding-002</c>
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ServiceId { get; set; }

	/// <summary>
	/// <para>
	/// The name of the workspace used for the inference task.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Workspace { get; set; }
}

public readonly partial struct AlibabaCloudServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AlibabaCloudServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AlibabaCloudServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key for the AlibabaCloud AI Search API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the host address used for the inference task.
	/// You can find the host address in the API keys section of the documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor Host(string value)
	{
		Instance.Host = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from AlibabaCloud AI Search.
	/// By default, the <c>alibabacloud-ai-search</c> service sets the number of requests allowed per minute to <c>1000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from AlibabaCloud AI Search.
	/// By default, the <c>alibabacloud-ai-search</c> service sets the number of requests allowed per minute to <c>1000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from AlibabaCloud AI Search.
	/// By default, the <c>alibabacloud-ai-search</c> service sets the number of requests allowed per minute to <c>1000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model service to use for the inference task.
	/// The following service IDs are available for the <c>completion</c> task:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ops-qwen-turbo</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>qwen-turbo</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>qwen-plus</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>qwen-max ÷ qwen-max-longcontext</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The following service ID is available for the <c>rerank</c> task:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ops-bge-reranker-larger</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The following service ID is available for the <c>sparse_embedding</c> task:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>ops-text-sparse-embedding-001</c>
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The following service IDs are available for the <c>text_embedding</c> task:
	/// </para>
	/// <para>
	/// <c>ops-text-embedding-001</c>
	/// <c>ops-text-embedding-zh-001</c>
	/// <c>ops-text-embedding-en-001</c>
	/// <c>ops-text-embedding-002</c>
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor ServiceId(string value)
	{
		Instance.ServiceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the workspace used for the inference task.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor Workspace(string value)
	{
		Instance.Workspace = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}