// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.AdaptiveAllocationsConverter))]
public sealed partial class AdaptiveAllocations
{
#if NET7_0_OR_GREATER
	public AdaptiveAllocations()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AdaptiveAllocations()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AdaptiveAllocations(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Turn on <c>adaptive_allocations</c>.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of allocations to scale to.
	/// If set, it must be greater than or equal to <c>min_number_of_allocations</c>.
	/// </para>
	/// </summary>
	public int? MaxNumberOfAllocations { get; set; }

	/// <summary>
	/// <para>
	/// The minimum number of allocations to scale to.
	/// If set, it must be greater than or equal to 0.
	/// If not defined, the deployment scales to 0.
	/// </para>
	/// </summary>
	public int? MinNumberOfAllocations { get; set; }
}

public readonly partial struct AdaptiveAllocationsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AdaptiveAllocationsDescriptor(Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AdaptiveAllocationsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor(Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations instance) => new Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations(Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Turn on <c>adaptive_allocations</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of allocations to scale to.
	/// If set, it must be greater than or equal to <c>min_number_of_allocations</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor MaxNumberOfAllocations(int? value)
	{
		Instance.MaxNumberOfAllocations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum number of allocations to scale to.
	/// If set, it must be greater than or equal to 0.
	/// If not defined, the deployment scales to 0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor MinNumberOfAllocations(int? value)
	{
		Instance.MinNumberOfAllocations = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations Build(System.Action<Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocationsDescriptor(new Elastic.Clients.Elasticsearch.Inference.AdaptiveAllocations(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}