// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.UpdatedDataStreamSettingsConverter))]
public sealed partial class UpdatedDataStreamSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdatedDataStreamSettings(bool appliedToDataStream, Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings effectiveSettings, Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingResults indexSettingsResults, string name, Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings settings)
	{
		AppliedToDataStream = appliedToDataStream;
		EffectiveSettings = effectiveSettings;
		IndexSettingsResults = indexSettingsResults;
		Name = name;
		Settings = settings;
	}
#if NET7_0_OR_GREATER
	public UpdatedDataStreamSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public UpdatedDataStreamSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdatedDataStreamSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If the settings were successfully applied to the data stream (or would have been, if running in <c>dry_run</c>
	/// mode), it is <c>true</c>. If an error occurred, it is <c>false</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool AppliedToDataStream { get; set; }

	/// <summary>
	/// <para>
	/// The settings that are effective on this data stream, taking into account the settings from the matching index
	/// template and the settings specific to this data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings EffectiveSettings { get; set; }

	/// <summary>
	/// <para>
	/// A message explaining why the settings could not be applied to the data stream.
	/// </para>
	/// </summary>
	public string? Error { get; set; }

	/// <summary>
	/// <para>
	/// Information about whether and where each setting was applied.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingResults IndexSettingsResults { get; set; }

	/// <summary>
	/// <para>
	/// The data stream name.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }

	/// <summary>
	/// <para>
	/// The settings that are specfic to this data stream that will override any settings from the matching index template.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Settings { get; set; }
}