// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class TranslogDurabilityConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAsync = System.Text.Json.JsonEncodedText.Encode("async");
	private static readonly System.Text.Json.JsonEncodedText MemberAsync1 = System.Text.Json.JsonEncodedText.Encode("ASYNC");
	private static readonly System.Text.Json.JsonEncodedText MemberRequest = System.Text.Json.JsonEncodedText.Encode("request");
	private static readonly System.Text.Json.JsonEncodedText MemberRequest1 = System.Text.Json.JsonEncodedText.Encode("REQUEST");

	public override Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAsync) || reader.ValueTextEquals(MemberAsync1))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability.Async;
		}

		if (reader.ValueTextEquals(MemberRequest) || reader.ValueTextEquals(MemberRequest1))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability.Request;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAsync.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberAsync1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability.Async;
		}

		if (string.Equals(value, MemberRequest.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberRequest1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability.Request;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability.Async:
				writer.WriteStringValue(MemberAsync);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability.Request:
				writer.WriteStringValue(MemberRequest);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}