// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class TranslogConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.Translog>
{
	private static readonly System.Text.Json.JsonEncodedText PropDurability = System.Text.Json.JsonEncodedText.Encode("durability");
	private static readonly System.Text.Json.JsonEncodedText PropFlushThresholdSize = System.Text.Json.JsonEncodedText.Encode("flush_threshold_size");
	private static readonly System.Text.Json.JsonEncodedText PropRetention = System.Text.Json.JsonEncodedText.Encode("retention");
	private static readonly System.Text.Json.JsonEncodedText PropSyncInterval = System.Text.Json.JsonEncodedText.Encode("sync_interval");

	public override Elastic.Clients.Elasticsearch.IndexManagement.Translog Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability?> propDurability = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propFlushThresholdSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.TranslogRetention?> propRetention = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propSyncInterval = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDurability.TryReadProperty(ref reader, options, PropDurability, static Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability>(o)))
			{
				continue;
			}

			if (propFlushThresholdSize.TryReadProperty(ref reader, options, PropFlushThresholdSize, null))
			{
				continue;
			}

			if (propRetention.TryReadProperty(ref reader, options, PropRetention, null))
			{
				continue;
			}

			if (propSyncInterval.TryReadProperty(ref reader, options, PropSyncInterval, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.Translog(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Durability = propDurability.Value,
			FlushThresholdSize = propFlushThresholdSize.Value,
			Retention = propRetention.Value,
			SyncInterval = propSyncInterval.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.Translog value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDurability, value.Durability, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.TranslogDurability>(o, v));
		writer.WriteProperty(options, PropFlushThresholdSize, value.FlushThresholdSize, null, null);
		writer.WriteProperty(options, PropRetention, value.Retention, null, null);
		writer.WriteProperty(options, PropSyncInterval, value.SyncInterval, null, null);
		writer.WriteEndObject();
	}
}