// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.StorageTypeConverter))]
public readonly partial struct StorageType : Elastic.Clients.Elasticsearch.Serialization.IEnumStruct<Elastic.Clients.Elasticsearch.IndexManagement.StorageType>
{
	public StorageType(string value) => Value = value;
#if NET7_0_OR_GREATER
	static StorageType IEnumStruct<StorageType>.Create(string value) => value;
#else
	StorageType IEnumStruct<StorageType>.Create(string value) => value;
#endif
	public readonly string Value { get; }

	/// <summary>
	/// <para>
	/// Default file system implementation. This will pick the best implementation depending on the operating environment, which
	/// is currently hybridfs on all supported systems but is subject to change.
	/// </para>
	/// </summary>
	public static StorageType Fs { get; } = new StorageType("fs");

	/// <summary>
	/// <para>
	/// The hybridfs type is a hybrid of niofs and mmapfs, which chooses the best file system type for each type of file
	/// based on the read access pattern. Currently only the Lucene term dictionary, norms and doc values files are memory
	/// mapped. All other files are opened using Lucene NIOFSDirectory. Similarly to mmapfs be sure you have allowed
	/// plenty of virtual address space.
	/// </para>
	/// </summary>
	public static StorageType Hybridfs { get; } = new StorageType("hybridfs");

	/// <summary>
	/// <para>
	/// The MMap FS type stores the shard index on the file system (maps to Lucene MMapDirectory) by mapping a file into
	/// memory (mmap). Memory mapping uses up a portion of the virtual memory address space in your process equal to the size
	/// of the file being mapped. Before using this class, be sure you have allowed plenty of virtual address space.
	/// </para>
	/// </summary>
	public static StorageType Mmapfs { get; } = new StorageType("mmapfs");

	/// <summary>
	/// <para>
	/// The NIO FS type stores the shard index on the file system (maps to Lucene NIOFSDirectory) using NIO. It allows multiple
	/// threads to read from the same file concurrently. It is not recommended on Windows because of a bug in the SUN Java
	/// implementation and disables some optimizations for heap memory usage.
	/// </para>
	/// </summary>
	public static StorageType Niofs { get; } = new StorageType("niofs");

	public override string ToString() => Value ?? string.Empty;

	public static implicit operator string(StorageType @enum) => @enum.Value;
	public static implicit operator StorageType(string value) => new(value);

	public override int GetHashCode() => Value.GetHashCode();
	public override bool Equals(object obj) => obj is StorageType other && this.Equals(other);
	public bool Equals(StorageType other) => Value == other.Value;

	public static bool operator ==(StorageType a, StorageType b) => a.Equals(b);
	public static bool operator !=(StorageType a, StorageType b) => !(a == b);
}