// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.StorageConverter))]
public sealed partial class Storage
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Storage(Elastic.Clients.Elasticsearch.IndexManagement.StorageType type)
	{
		Type = type;
	}
#if NET7_0_OR_GREATER
	public Storage()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Storage()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Storage(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// You can restrict the use of the mmapfs and the related hybridfs store type via the setting node.store.allow_mmap.
	/// This is a boolean setting indicating whether or not memory-mapping is allowed. The default is to allow it. This
	/// setting is useful, for example, if you are in an environment where you can not control the ability to create a lot
	/// of memory maps so you need disable the ability to use memory-mapping.
	/// </para>
	/// </summary>
	public bool? AllowMmap { get; set; }

	/// <summary>
	/// <para>
	/// How often store statistics are refreshed
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? StatsRefreshInterval { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.StorageType Type { get; set; }
}

public readonly partial struct StorageDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.Storage Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StorageDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.Storage instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StorageDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.Storage(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.Storage instance) => new Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.Storage(Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// You can restrict the use of the mmapfs and the related hybridfs store type via the setting node.store.allow_mmap.
	/// This is a boolean setting indicating whether or not memory-mapping is allowed. The default is to allow it. This
	/// setting is useful, for example, if you are in an environment where you can not control the ability to create a lot
	/// of memory maps so you need disable the ability to use memory-mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor AllowMmap(bool? value = true)
	{
		Instance.AllowMmap = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How often store statistics are refreshed
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor StatsRefreshInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.StatsRefreshInterval = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor Type(Elastic.Clients.Elasticsearch.IndexManagement.StorageType value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.Storage Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.Storage(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}