// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class SourceModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.SourceMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDisabled = System.Text.Json.JsonEncodedText.Encode("disabled");
	private static readonly System.Text.Json.JsonEncodedText MemberStored = System.Text.Json.JsonEncodedText.Encode("stored");
	private static readonly System.Text.Json.JsonEncodedText MemberSynthetic = System.Text.Json.JsonEncodedText.Encode("synthetic");

	public override Elastic.Clients.Elasticsearch.IndexManagement.SourceMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDisabled))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Disabled;
		}

		if (reader.ValueTextEquals(MemberStored))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Stored;
		}

		if (reader.ValueTextEquals(MemberSynthetic))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Synthetic;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDisabled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Disabled;
		}

		if (string.Equals(value, MemberStored.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Stored;
		}

		if (string.Equals(value, MemberSynthetic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Synthetic;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.SourceMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SourceMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Disabled:
				writer.WriteStringValue(MemberDisabled);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Stored:
				writer.WriteStringValue(MemberStored);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.SourceMode.Synthetic:
				writer.WriteStringValue(MemberSynthetic);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.SourceMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.SourceMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SourceMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}